/* Distributed Checksum Clearinghouse
 *
 * server-IDs
 *
 * Copyright (c) 2005 by Rhyolite Software, LLC
 *
 * This agreement is not applicable to any entity which sells anti-spam
 * solutions to others or provides an anti-spam solution as part of a
 * security solution sold to other entities, or to a private network
 * which employs the DCC or uses data provided by operation of the DCC
 * but does not provide corresponding data to other users.
 *
 * Permission to use, copy, modify, and distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * Parties not eligible to receive a license under this agreement can
 * obtain a commercial license to use DCC and permission to use
 * U.S. Patent 6,330,590 by contacting Commtouch at http://www.commtouch.com/
 * or by email to nospam@commtouch.com.
 *
 * A commercial license would be for Distributed Checksum and Reputation
 * Clearinghouse software.  That software includes additional features.  This
 * free license for Distributed ChecksumClearinghouse Software does not in any
 * way grant permision to use Distributed Checksum and Reputation Clearinghouse
 * software
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND RHYOLITE SOFTWARE, LLC DISCLAIMS ALL
 * WARRANTIES WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL RHYOLITE SOFTWARE, LLC
 * BE LIABLE FOR ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES
 * OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 *
 * Rhyolite Software DCC 1.3.42-1.23 $Revision$
 */

#ifndef DCC_IDS_H
#define DCC_IDS_H

/* IDs file used by server, server utilities, and cdcc */
extern DCC_PATH ids_path;
extern time_t ids_mtime;
#define IDS_NM_DEF  "ids"


/* authenticated client database */
typedef struct id_tbl {
    struct id_tbl *fwd;
    DCC_CLNT_ID	id;
    time_t	delay_us;
#    define	 DCC_ANON_DELAY_US_DEF	(50*1000)
    u_int	delay_inflate;
#    define	 DCC_ANON_INFLATE_OFF	((u_int)(-1))
    u_char	flags;
#    define	 ID_FLG_MARKED	0x01	/* for garbage collection */
#    define	 ID_FLG_RPT_OK	0x02	/* override dccd -Q */
    DCC_PASSWD	cur_passwd;
    DCC_PASSWD	next_passwd;
} ID_TBL;

extern u_char parse_dccd_delay(DCC_EMSG, time_t *, u_int *,
			       const char *, const char *, int);
extern ID_TBL *find_id_tbl(DCC_CLNT_ID);
extern u_char set_ids_path(DCC_EMSG, const char *);
extern int load_ids(DCC_EMSG, ID_TBL **, DCC_CLNT_ID);
extern u_char check_load_ids(DCC_EMSG, DCC_CLNT_ID);

#endif /* DCC_IDS_H */
