/* Distributed Checksum Clearinghouse
 *
 * DNS blacklist and external filter definitions
 *
 * Copyright (c) 2005 by Rhyolite Software, LLC
 *
 * This agreement is not applicable to any entity which sells anti-spam
 * solutions to others or provides an anti-spam solution as part of a
 * security solution sold to other entities, or to a private network
 * which employs the DCC or uses data provided by operation of the DCC
 * but does not provide corresponding data to other users.
 *
 * Permission to use, copy, modify, and distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * Parties not eligible to receive a license under this agreement can
 * obtain a commercial license to use DCC and permission to use
 * U.S. Patent 6,330,590 by contacting Commtouch at http://www.commtouch.com/
 * or by email to nospam@commtouch.com.
 *
 * A commercial license would be for Distributed Checksum and Reputation
 * Clearinghouse software.  That software includes additional features.  This
 * free license for Distributed ChecksumClearinghouse Software does not in any
 * way grant permision to use Distributed Checksum and Reputation Clearinghouse
 * software
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND RHYOLITE SOFTWARE, LLC DISCLAIMS ALL
 * WARRANTIES WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL RHYOLITE SOFTWARE, LLC
 * BE LIABLE FOR ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES
 * OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 *
 * Rhyolite Software DCC 1.3.42-1.17 $Revision$
 */

#ifndef HELPER_H
#define HELPER_H

#include "dcc_ck.h"

extern u_char helpers_threaded;

#define HELPER_PAT "helper=%u,%u"

typedef struct {
    const char	*type_str;
    /* save the socket and its port number obtained for the first child
     * to give to later children */
    SOCKET	soc;
    DCC_SOCKU	su;
    int		req_len;
    int		argc;
    int		free_args;
    const char	*progpath;
    char const	**argv;
    pid_t	*pids;
    int		max_threads;
    int		cur_threads;
    int		total_helpers;
    int		max_helpers;
    int		idle_helpers;
    int		debug;
    struct timeval started;		/* when last new helper started */
} HELPER_PARENT;

typedef struct {
    HELPER_PARENT *parent;
    SOCKET	soc;
    DCC_SOCKU	su;
} HELPER_CHILD;

extern HELPER_PARENT dnsbl_helper_parent;
extern HELPER_PARENT xfltr_helper_parent;


typedef struct {
    u_int	magic;
    u_int	sn;
    struct timeval start;
    time_t	total_usecs;
    char	id[DCC_MSG_ID_LEN+1];
} HELPER_REQ_HDR;

typedef struct {
    u_int	magic;
    u_int	sn;
} HELPER_RESP_HDR;

#define HELPER_MAGIC_REQ    0xbeefdead
#define HELPER_MAGIC_RESP   0xdeadbeef

typedef struct {
    HELPER_REQ_HDR hdr;
    DNSBL_HIT	hit;
    DNSBL_DOM   tgt_dom;
    struct in6_addr tgt_addr;
} DNSBL_REQ;

typedef struct {
    HELPER_RESP_HDR hdr;
    DNSBL_HIT	hit;
    DNSBL_DOM	probe;
    int		bl_num;
} DNSBL_RESP;

typedef struct {
    HELPER_REQ_HDR hdr;
    int		targets;
    char	helo[DCC_HELO_MAX];
    char	clnt_name[MAXHOSTNAMELEN];
    struct in6_addr clnt_addr;
    char	env_from[DCC_ENV_FROM_MAX+1];
    DCC_PATH	tmp_nm;			/* file containing the mail message */
} XFLTR_REQ;

typedef struct {
    HELPER_RESP_HDR hdr;
    u_int	sn;
    u_short	header_len;		/* does not count terminal '\0' */
    u_char	reject;
    char	header[DCC_MAX_XHDR_LEN+1]; /* SMTP header to add to message */
} XFLTR_RESP;


extern void helper_save_arg(u_char, const char *);
#ifdef HAVE_HELPERS
extern void * NRATTRIB helper_thread(void *);
extern void NRATTRIB helper_child(u_char, SOCKET, int);
#endif

extern u_char ask_helper(DCC_CLNT_CTXT *, u_char, void *,
			 const struct timeval *, time_t,
			 HELPER_REQ_HDR *, int, HELPER_RESP_HDR *, int);

extern u_char dnsbl_work(const DNSBL_REQ *, DNSBL_RESP *);

extern u_char xfltr_work(const XFLTR_REQ *, XFLTR_RESP *);

extern u_char xfltr_new_thread(u_char);
extern void NRATTRIB xfltr_old_thread(u_char);
extern u_char xfltr_thread_create(const char *, void *);

/* these are defined in the external filter */
extern int xfltr_threads;
extern u_char xfltr_open(void);
extern u_char xfltr_thread_start(void);
extern void xfltr_thread_stop(void);
extern void xfltr_close(void);


#endif /* HELPER_H */
