<?php
/*
 * $Id: class.dbChklstTpl.inc.php,v 1.1.1.1 2001/08/09 02:38:12 mdean Exp $
 *
 * Double Choco Latte - Source Configuration Management System
 * Copyright (C) 1999  Michael L. Dean & Tim R. Norman
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * Select License Info from the Help menu to view the terms and conditions of this license.
 */

LoadStringResource('db');
class dbChklstTpl extends dclDB
{
	var $dcl_chklst_tpl_id;
	var $dcl_chklst_tpl_name;
	var $dcl_chklst_tpl_active;

	function dbChklstTpl()
	{
           // Table Fields
		$this->fieldArray = array(
				'dcl_chklst_tpl_id',
				'dcl_chklst_tpl_name',
				'dcl_chklst_tpl_active'
			);

           // Foreign keys
		$this->foreignKeys = array('dcl_chklst' => 'dcl_chklst_tpl_id');

		$this->cache = array();
		$this->cacheEnabled = false;

		$this->dclDB();
	}

	function Add()
	{
		global $dcl_info, $dcl_domain, $dcl_domain_info;

		$idSQL = $this->GetNewIDSQLForTable('dcl_chklst_tpl');
		$query = 'INSERT INTO dcl_chklst_tpl (';
		if ($idSQL != '')
			$query .= 'dcl_chklst_tpl_id,';
		$query .= 'dcl_chklst_tpl_name) VALUES (';
		if ($idSQL != '')
			$query .= $idSQL . ',';

		$query .= '\'' . $this->DBAddSlashes($this->dcl_chklst_tpl_name) . '\')';

		if ($this->Insert($query) == -1)
		{
			echo '<BR>' . sprintf(STR_DB_INSERTERR, $query) . '<BR>';
		}
		else
		{
			if ($dcl_domain_info[$dcl_domain]['dbType'] == 'pgsql')
				$this->Query('SELECT * FROM dcl_chklst_tpl WHERE oid=' . $this->oid);
			else
				$this->Query('SELECT * FROM dcl_chklst_tpl WHERE dcl_chklst_tpl_id=' . $this->oid);

			if ($this->res)
				$this->GetRow();
			else
				printf(STR_DB_CHKLSTTPLOIDERR, $this->oid);
		}
	}

	function Edit()
	{
		$query = 'UPDATE dcl_chklst_tpl SET ';
		$query .= 'dcl_chklst_tpl_name=\'' . $this->DBAddSlashes($this->dcl_chklst_tpl_name) . '\',';
		$query .= 'dcl_chklst_tpl_active=\'' . $this->DBAddSlashes($this->dcl_chklst_tpl_active) . '\'';
		$query .= ' WHERE dcl_chklst_tpl_id=' . $this->dcl_chklst_tpl_id;

		$this->Execute($query);
	}

	function Delete()
	{
		$query = 'DELETE FROM dcl_chklst_tpl WHERE dcl_chklst_tpl_id=' . $this->dcl_chklst_tpl_id;
		return $this->Execute($query);
	}

	function GetRow()
	{
		if (!$this->res)
			return -1;

		if ($this->next_record())
		{
			$this->dcl_chklst_tpl_id = $this->f('dcl_chklst_tpl_id');
			$this->dcl_chklst_tpl_name = $this->f('dcl_chklst_tpl_name');
			$this->dcl_chklst_tpl_active = $this->f('dcl_chklst_tpl_active');

			if ($this->cacheEnabled)
				$this->CacheRow($this->dcl_chklst_tpl_id);
		}
		else
			$this->Clear();
	}

	function Load($id)
	{
		$this->Clear();

		if ($this->cacheEnabled && $this->LoadCache($id) != -1)
			return 0;

		if ($this->conn == 0)
		{
			if (!$this->Connect())
				return -1;
		}

		$sql = 'SELECT dcl_chklst_tpl_id, dcl_chklst_tpl_name, dcl_chklst_tpl_active ';
		$sql .= "FROM dcl_chklst_tpl WHERE dcl_chklst_tpl_id=$id";

		if (!$this->Query($sql))
			return -1;

		return $this->GetRow();
	}

	function Clear()
	{
		$this->dcl_chklst_tpl_id = 0;
		$this->dcl_chklst_tpl_name = '';
		$this->dcl_chklst_tpl_active = '';
	}
}
?>
