<?php
/*
 * $Id: class.htmlWOSearches.inc.php,v 1.2.4.18 2003/12/10 05:54:06 mdean Exp $
 *
 * Double Choco Latte - Source Configuration Management System
 * Copyright (C) 1999  Michael L. Dean & Tim R. Norman
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * Select License Info from the Help menu to view the terms and conditions of this license.
 */

LoadStringResource('wo');

class htmlWOSearches
{
	function ShowView()
	{
		commonHeader();

		$oDB = CreateObject('dcl.dbViews');
		$oDB->Connect();
		if ($oDB->Load($GLOBALS['id']) != -1)
		{
			$oView = CreateObject('dcl.boView');
			$oView->SetFromURLString($oDB->viewurl);
			$this->Show($oView);
		}
	}

	function ShowRequest()
	{
		commonHeader();

		$oView = CreateObject('dcl.boView');
		$oView->SetFromURL();
		$this->Show($oView);
	}

	function Show($oView = '')
	{
		global $dcl_info;

		commonHeader();
		
		IncludeCalendar();
		$bView = is_object($oView);

		$objJS = CreateObject('dcl.jsAttributesets');
		$objJS->bModules = true;
		$objJS->bStatusTypes = true;
		$objJS->bDepartments = true;
		$objJS->DisplayAttributeScript();

		$objPersonnel = CreateObject('dcl.htmlPersonnel');
		$objDepartment = CreateObject('dcl.htmlDepartments');
		$objProducts = CreateObject('dcl.htmlProducts');
		$objPriorities = CreateObject('dcl.htmlPriorities');
		$objSeverities = CreateObject('dcl.htmlSeverities');
		$objAccounts = CreateObject('dcl.htmlAccounts');
		$objStatuses = CreateObject('dcl.htmlStatuses');
		$objProjects = CreateObject('dcl.htmlProjects');
		$objModules = CreateObject('dcl.htmlProductModules');
		$objType = CreateObject('dcl.htmlWorkOrderType');
		
		$oDBP = CreateObject('dcl.dbPersonnel');
		$oDBP->Load($GLOBALS['DCLID']);

		$Template = CreateTemplate(array('hForm' => 'htmlWorkOrderSearch.tpl'));
		$Template->set_block('hForm', 'acols', 'hAcols');
		$Template->set_block('hForm', 'columnlist', 'hColumnlist');
		$Template->set_block('hForm', 'grouplist', 'hGrouplist');
		$Template->set_block('hForm', 'sortlist', 'hSortlist');

		$Template->set_var('hAcols', '');
		$Template->set_var('hColumnlist', '');
		$Template->set_var('hGrouplist', '');
		$Template->set_var('hSortlist', '');

		$Template->set_var('VAL_JSDATEFORMAT', GetJSDateFormat());
		$Template->set_var('VAL_FORMACTION', menuLink());
		$Template->set_var('COLOR_DARK', $dcl_info['DCL_COLOR_DARK']);
		$Template->set_var('COLOR_LIGHT', $dcl_info['DCL_COLOR_LIGHT']);
		$Template->set_var('IMG_RIGHT', 'img/false.gif');
		$Template->set_var('IMG_DOWN', 'img/true.gif');

		$Template->set_var('BTN_SEARCH', STR_CMMN_SEARCH);
		$Template->set_var('BTN_RESET', STR_CMMN_RESET);
		$Template->set_var('BTN_COL', STR_CMMN_COL);
		$Template->set_var('BTN_GRP', STR_CMMN_GRP);
		$Template->set_var('BTN_ORD', STR_CMMN_SRT);
		$Template->set_var('BTN_RM', STR_CMMN_RM);
		$Template->set_var('BTN_UP', STR_CMMN_UP);
		$Template->set_var('BTN_DN', STR_CMMN_DN);

		$Template->set_var('TXT_TITLE', STR_WO_SEARCHTITLE);
		$Template->set_var('LNK_HELP', GetHelpLink());
		$Template->set_var('TXT_RESPONSIBLE', STR_WO_RESPONSIBLE);
		$Template->set_var('TXT_OPENBY', STR_WO_OPENBY);
		$Template->set_var('TXT_CLOSEBY', STR_WO_CLOSEBY);
		$Template->set_var('TXT_PRODUCT', STR_WO_PRODUCT);
		$Template->set_var('TXT_PRIORITY', STR_WO_PRIORITY);
		$Template->set_var('TXT_SEVERITY', STR_WO_SEVERITY);
		$Template->set_var('TXT_ACCOUNT', STR_WO_ACCOUNT);
		$Template->set_var('TXT_STATUS', STR_WO_STATUS);
		$Template->set_var('TXT_OPENEDON', STR_WO_OPENEDON);
		$Template->set_var('TXT_CLOSEDON', STR_WO_CLOSEDON);
		$Template->set_var('TXT_STATUSON', STR_WO_STATUSON);
		$Template->set_var('TXT_LASTACTION', STR_WO_LASTACTION);
		$Template->set_var('TXT_DEADLINE', STR_WO_DEADLINE);
		$Template->set_var('TXT_ESTSTART', STR_WO_ESTSTART);
		$Template->set_var('TXT_ESTEND', STR_WO_ESTEND);
		$Template->set_var('TXT_START', STR_WO_START);
		$Template->set_var('TXT_SUMMARY', STR_WO_SUMMARY);
		$Template->set_var('TXT_NOTES', STR_WO_NOTES);
		$Template->set_var('TXT_DESCRIPTION', STR_WO_DESCRIPTION);
		$Template->set_var('TXT_FROM', STR_CMMN_FROM);
		$Template->set_var('TXT_TO', STR_CMMN_TO);
		$Template->set_var('TXT_REPORTOPTIONS', STR_WO_REPORTOPTIONS);
		$Template->set_var('TXT_REPORTTITLE', STR_CMMN_TITLE);
		$Template->set_var('TXT_STYLE', STR_CMMN_STYLE);
		$Template->set_var('TXT_AVAILABLECOLUMNS', STR_CMMN_AVAILCOLS);
		$Template->set_var('TXT_SHOWCOLUMNS', STR_CMMN_SHOWCOLS);
		$Template->set_var('TXT_GROUPING', STR_CMMN_GROUPING);
		$Template->set_var('TXT_SORTING', STR_CMMN_SORTING);
		$Template->set_var('TXT_PROJECT', STR_WO_PROJECT);
		$Template->set_var('TXT_MODULE', STR_CMMN_MODULE);
		$Template->set_var('TXT_STATUSTYPE', STR_CMMN_STATUSTYPE);
		$Template->set_var('TXT_TYPE', STR_WO_TYPE);
		$Template->set_var('TXT_PERSONNEL', 'Personnel');
		$Template->set_var('TXT_DEPARTMENT', 'Department');

		if ($bView)
			$Template->set_var('VAL_REPORTTITLE', $oView->title);
		else
			$Template->set_var('VAL_REPORTTITLE', '');

		$Template->set_var('VAL_DEPARTMENT', $oDBP->department);
		$Template->set_var('VAL_ID', $GLOBALS['DCLID']);

		$aDefault['product'] = array();
		$aDefault['priority'] = array();
		$aDefault['severity'] = array();
		$aDefault['dcl_wo_account.account_id'] = array();
		$aDefault['status'] = array();
		$aDefault['project'] = array();
		$aDefault['wo_type_id'] = array();
		$aDefault['statuses.dcl_status_type'] = array();
		$aDefault['department'] = array();
		$aDefault['personnel'] = array();
		$sPersonnelKey = '';
		$sStatusKey = '';
		$sModuleKey = '';

		if ($bView)
		{
			reset($oView->filter);
			while (list($field, $values) = each($oView->filter))
			{
				if (substr($field, 1) == '.department')
				{
					if ($field[0] == 'a')
						$Template->set_var('CHK_RESPONSIBLE', ' checked');
					else if ($field[0] == 'b')
						$Template->set_var('CHK_CREATEBY', ' checked');
					else if ($field[0] == 'c')
						$Template->set_var('CHK_CLOSEDBY', ' checked');

					$field = 'department';
					$sPersonnelKey = '';
				}
				else if ($field == 'responsible' || $field == 'createby' || $field == 'closedby')
				{
					$Template->set_var('CHK_' . strtoupper($field), ' checked');
					$field = 'personnel';
					$sPersonnelKey = '';
				}
				else if ($field == 'account')
				{
					$field = 'dcl_wo_account.account_id';
				}
				else if ($field == 'dcl_projects.projectid')
				{
					$field = 'project';
				}

				if (array_key_exists($field, $aDefault))
					$aDefault[$field] = $values;
			}

			if (isset($aDefault['personnel']) && is_array($aDefault['personnel']) && count($aDefault['personnel']) > 0)
			{
				$sPersonnel = implode(',', $aDefault['personnel']);
				$oDBP->Query("select department, id from personnel where id in ($sPersonnel)");
				while ($oDBP->next_record())
				{
					if (!in_array($oDBP->f(0), $aDefault['department']))
						$aDefault['department'][] = $oDBP->f(0);

					if ($sPersonnelKey != '')
						$sPersonnelKey .= ':';

					$sPersonnelKey .= sprintf('%d,%d', $oDBP->f(0), $oDBP->f(1));
				}
			}

			if (isset($aDefault['status']) && is_array($aDefault['status']) && count($aDefault['status']) > 0)
			{
				$sStatus = implode(',', $aDefault['status']);
				$oDBP->Query("select dcl_status_type, id from statuses where id in ($sStatus)");
				while ($oDBP->next_record())
				{
					if (!in_array($oDBP->f(0), $aDefault['statuses.dcl_status_type']))
						$aDefault['statuses.dcl_status_type'][] = $oDBP->f(0);

					if ($sStatusKey != '')
						$sStatusKey .= ':';

					$sStatusKey .= sprintf('%d,%d', $oDBP->f(0), $oDBP->f(1));
				}
			}

			if (isset($aDefault['module']) && is_array($aDefault['module']) && count($aDefault['module']) > 0)
			{
				$sModule = implode(',', $aDefault['module']);
				$oDBP->Query("select product_id, product_module_id from module where product_module_id in ($sModule)");
				while ($oDBP->next_record())
				{
					if (!in_array($oDBP->f(0), $aDefault['product']))
						$aDefault['product'][] = $oDBP->f(0);

					if ($sModuleKey != '')
						$sModuleKey .= ':';

					$sModuleKey .= sprintf('%d,%d', $oDBP->f(0), $oDBP->f(1));
				}
			}
		}
		else
		{
			$aDefault['product'] = 0;
			$aDefault['priority'] = 0;
			$aDefault['severity'] = 0;
			$aDefault['dcl_wo_account.account_id'] = 0;
			$aDefault['status'] = 0;
			$aDefault['project'] = 0;
			$aDefault['wo_type_id'] = 0;
			$aDefault['statuses.dcl_status_type'] = 1;
			$aDefault['department'] = array($oDBP->department);
			$aDefault['personnel'] = $GLOBALS['DCLID'];
			$sPersonnelKey = sprintf('%d,%d', $oDBP->department, $GLOBALS['DCLID']);
			$sStatusKey = '';
			$sModuleKey = '';

			if ($GLOBALS['SEC'] >= $dcl_info['DCL_HAVE_WO'])
			{
				$Template->set_var('CHK_RESPONSIBLE', ' checked');
				$Template->set_var('CHK_CREATEBY', '');
				$Template->set_var('CHK_CLOSEDBY', '');
			}
			else
			{
				$Template->set_var('CHK_CREATEBY', ' checked');
				$Template->set_var('CHK_RESPONSIBLE', '');
				$Template->set_var('CHK_CLOSEDBY', '');
			}
		}

		$Template->set_var('VAL_SELECTPERSONNELKEY', $sPersonnelKey);
		$Template->set_var('VAL_SELECTSTATUSKEY', $sStatusKey);
		$Template->set_var('VAL_SELECTMODULEKEY', $sModuleKey);
		$Template->set_var('CMB_PERSONNEL', $objPersonnel->GetCombo($aDefault['personnel'], 'personnel', 'lastfirst', 8, false));
		$Template->set_var('CMB_DEPARTMENTS', $objDepartment->GetCombo($aDefault['department'], 'department', 'name', 8, false));
		$Template->set_var('CMB_PRODUCTS', $objProducts->GetCombo($aDefault['product'], 'product', 'name', 0, 8, false));
		$Template->set_var('CMB_PRIORITIES', $objPriorities->GetCombo($aDefault['priority'], 'priority', 'name', 8, false));
		$Template->set_var('CMB_SEVERITIES', $objSeverities->GetCombo($aDefault['severity'], 'severity', 'name', 8, false));
		$Template->set_var('CMB_ACCOUNTS', $objAccounts->GetCombo($aDefault['dcl_wo_account.account_id'], 'account', 'name', 8, false));
		$Template->set_var('CMB_STATUSES', $objStatuses->GetCombo($aDefault['status'], 'status', 'name', 8));
		$Template->set_var('CMB_PROJECTS', $objProjects->GetCombo($aDefault['project'], 'project', 'name', 8));
		$Template->set_var('CMB_TYPE', $objType->GetCombo($aDefault['wo_type_id'], 'wo_type_id', 8, false));

		// Modules only show for selected products
		$obj = CreateObject('dcl.htmlSelect');
		$obj->sName = 'module_id';
		$obj->iSize = 8;
		$Template->set_var('CMB_MODULES', $obj->GetHTML());

		// Empty status is for selecting status type, then filtering status if desired
		$obj->sName = 'status';
		$obj->iSize = 8;
		$Template->set_var('CMB_STATUSESEMPTY', $obj->GetHTML());

		// Status Types
		$obj->sName = 'dcl_status_type';
		$obj->iSize = 8;
		$obj->vDefault = $aDefault['statuses.dcl_status_type'];
		$obj->SetOptionsFromDb('dcl_status_type', 'dcl_status_type_id', 'dcl_status_type_name', '', 'dcl_status_type_id');
		$Template->set_var('CMB_STATUSTYPES', $obj->GetHTML());

		$Template->set_var('CHK_SUMMARY', '');
		$Template->set_var('CHK_NOTES', '');
		$Template->set_var('CHK_DESCRIPTION', '');
		$Template->set_var('VAL_SEARCHTEXT', '');
		if ($bView && count($oView->filterlike) > 0)
		{
			$searchText = '';
			foreach ($oView->filterlike as $field => $values)
			{
				if ($field == 'summary' || $field == 'notes' || $field == 'description')
				{
					$Template->set_var('CHK_' . strtoupper($field), ' CHECKED');
					$searchText = $values[0];
				}
			}

			$Template->set_var('VAL_SEARCHTEXT', $searchText);
		}

		$aDateChecks = array('createdon', 'closedon', 'statuson', 'lastactionon',
							'deadlineon', 'eststarton', 'estendon', 'starton');

		for ($i = 0; $i < count($aDateChecks); $i++)
			$Template->set_var('CHK_' . strtoupper($aDateChecks[$i]), '');

		if ($bView)
		{
			$Template->set_var('VAL_DATEFROM', '');
			$Template->set_var('VAL_DATETO', '');
			if (count($oView->filterdate) > 0)
			{
				$fromDate = '';
				$toDate = '';
				
				foreach ($oView->filterdate as $field => $values)
				{
					$Template->set_var('CHK_' . strtoupper($field), ' CHECKED');
					$fromDate = $values[0];
					$toDate = $values[1];
				}

				$Template->set_var('VAL_DATEFROM', $fromDate);
				$Template->set_var('VAL_DATETO', $toDate);
			}
		}
		else
		{
			$aFewDaysAgo = mktime(0, 0, 0, date('m'), date('d') - 3, date('Y'));
			$Template->set_var('VAL_DATEFROM', date($dcl_info['DCL_DATE_FORMAT'], $aFewDaysAgo));
			$Template->set_var('VAL_DATETO', date($dcl_info['DCL_DATE_FORMAT']));
		}

		$aCols = array(
				'jcn' => STR_WO_JCN,
				'seq' => STR_WO_SEQ,
				'dcl_wo_type.type_name' => STR_WO_TYPE,
				'responsible.short' => STR_WO_RESPONSIBLE,
				'products.name' => STR_WO_PRODUCT,
				'statuses.name' => STR_WO_STATUS,
				'summary' => STR_WO_SUMMARY,
				'dcl_product_module.module_name' => STR_CMMN_MODULE,
				'dcl_projects.name' => STR_WO_PROJECT,
				'accounts.name' => STR_WO_ACCOUNT,
				'createby.short' => STR_WO_OPENBY,
				'createdon' => STR_WO_OPENEDON,
				'closedby.short' => STR_WO_CLOSEBY,
				'closedon' => STR_WO_CLOSEDON,
				'statuson' => STR_WO_STATUSON,
				'lastactionon' => STR_WO_LASTACTION,
				'deadlineon' => STR_WO_DEADLINE,
				'eststarton' => STR_WO_ESTSTART,
				'estendon' => STR_WO_ESTEND,
				'starton' => STR_WO_START,
				'esthours' => STR_WO_ESTHOURS,
				'etchours' => STR_WO_ETCHOURS,
				'totalhours' => STR_WO_ACTHOURS,
				'priorities.name' => STR_WO_PRIORITY,
				'severities.name' => STR_WO_SEVERITY,
				'revision' => STR_WO_REVISION,
				'contact' => STR_WO_CONTACT,
				'contactphone' => STR_WO_CONTACTPHONE,
				'notes' => STR_WO_NOTES,
				'description' => STR_WO_DESCRIPTION,
				'dcl_status_type.dcl_status_type_name' => STR_CMMN_STATUSTYPE
			);

		if ($bView)
		{
			$aShow = array();
			$aGroup = array();
			
			foreach ($oView->columns as $colName)
			{
				if ($colName == 'a.short')
					$colName = 'responsible.short';
				else if ($colName == 'b.short')
					$colName = 'closedby.short';
				else if ($colName == 'c.short')
					$colName = 'createby.short';

				$aShow[$colName] = $aCols[$colName];
			}

			foreach ($oView->groups as $colName)
			{
				if ($colName == 'a.short')
					$colName = 'responsible.short';
				else if ($colName == 'b.short')
					$colName = 'closedby.short';
				else if ($colName == 'c.short')
					$colName = 'createby.short';

				$aGroup[$colName] = $aCols[$colName];
			}
		}
		else
		{
			$aShow = array(
					'jcn' => STR_WO_JCN,
					'seq' => STR_WO_SEQ,
					'dcl_wo_type.type_name' => STR_WO_TYPE,
					'responsible.short' => STR_WO_RESPONSIBLE,
					'products.name' => STR_WO_PRODUCT,
					'statuses.name' => STR_WO_STATUS,
					'summary' => STR_WO_SUMMARY
				);

			$aGroup = array();
		}

		array_remove_keys($aCols, $aShow);
		array_remove_keys($aCols, $aGroup);

		foreach ($aCols as $val => $text)
		{
			$Template->set_var('VAL_ACOLSVALUE', htmlspecialchars($val));
			$Template->set_var('VAL_ACOLSTEXT', htmlspecialchars($text));
			$Template->parse('hAcols', 'acols', true);
		}

		foreach ($aShow as $val => $text)
		{
			$Template->set_var('VAL_COLSVALUE', htmlspecialchars($val));
			$Template->set_var('VAL_COLSTEXT', htmlspecialchars($text));
			$Template->parse('hColumnlist', 'columnlist', true);
		}

		foreach ($aGroup as $val => $text)
		{
			$Template->set_var('VAL_GRPVALUE', htmlspecialchars($val));
			$Template->set_var('VAL_GRPTEXT', htmlspecialchars($text));
			$Template->parse('hGrouplist', 'grouplist', true);
		}

		if ($bView)
		{
			foreach ($oView->order as $val)
			{
				$Template->set_var('VAL_SRTVALUE', htmlspecialchars($val));

				if ($val == 'priorities.weight')
					$sText = $aShow['priorities.name'];
				else if ($val == 'severities.weight')
					$sText = $aShow['severities.name'];
				else if (IsSet($aShow[$val]))
					$sText = $aShow[$val];

				$Template->set_var('VAL_SRTTEXT', htmlspecialchars($sText));
				$Template->parse('hSortlist', 'sortlist', true);
			}
		}

		$Template->pparse('out', 'hForm');
	}

	function my()
	{
		$t = CreateTemplate(array('hForm' => 'htmlMyWorkorderSearches.tpl'));

		$t->set_var('TXT_TITLE', STR_WO_MYWOSEARCHES);
		$t->set_var('FORM_ACTION', menuLink());
		$t->set_var('TXT_WOID', STR_WO_JCN);
		$t->set_var('TXT_SEQ', STR_WO_SEQ);
		$t->set_var('TXT_FIND', STR_CMMN_FIND);
		$t->set_var('TXT_VIEW', STR_CMMN_VIEW);
		$t->set_var('COLOR_DARK', $GLOBALS['dcl_info']['DCL_COLOR_DARK']);
		$t->set_var('COLOR_LIGHT',$GLOBALS['dcl_info']['DCL_COLOR_LIGHT']);

		$obj = CreateObject('dcl.htmlViews');
		$t->set_var('CMB_VIEWS', $obj->GetCombo(0, 'viewid', 0, true, 'workorders'));

		$t->pparse('out', 'hForm');
	}
}
?>
