<?php
/*
 * $Id: class.htmlWindowList.inc.php,v 1.1.2.2 2003/10/19 21:25:07 mdean Exp $
 *
 * Double Choco Latte - Source Configuration Management System
 * Copyright (C) 1999  Michael L. Dean & Tim R. Norman
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * Select License Info from the Help menu to view the terms and conditions of this license.
 */

class htmlWindowList
{
	var $vDefault;
	var $t;
	var $oDB;

	function htmlWindowList()
	{
		$this->oDB = null;
	}

	function GetHTML($part = 'all')
	{
		global $dcl_info;
		$_SRC = $GLOBALS[GetSourceArray()];

		if ($part == 'top')
		{
			$this->t->set_var('TXT_TITLE', 'Work Order ' . $_SRC['wo_id'] . '-' . $_SRC['seq'] . ' Accounts');
			$this->t->set_var('TXT_OK', STR_CMMN_OK);
			$this->t->set_var('TXT_PRINT', STR_CMMN_PRINT);
			$this->t->set_var('COLOR_DARK', $dcl_info['DCL_COLOR_DARK']);
			$this->t->set_var('COLOR_LIGHT', $dcl_info['DCL_COLOR_LIGHT']);
		}
		else if ($part == 'main')
		{
			$this->t->set_block('hForm', 'sel', 'hSel');
			$this->t->set_var('hSel', '');
			$this->t->set_var('COLOR_DARK', $dcl_info['DCL_COLOR_DARK']);
			$this->t->set_var('COLOR_LIGHT', $dcl_info['DCL_COLOR_LIGHT']);
			switch ($_SRC['what'])
			{
				case 'dcl_wo_account.wo_id':
					$this->ListFromDb('dcl_wo_account', 'name', 'wo_id = ' . $_SRC['wo_id'] . ' And seq = ' . $_SRC['seq'], 'name');
					break;
				default:
					PrintPermissionDenied();
					return "";
			}
		}
		else
		{
			$this->t = CreateTemplate(array('hForm' => 'htmlWindowList.tpl'));

			$this->t->set_var('TXT_TITLE', 'Work Order ' . $_SRC['wo_id'] . '-' . $_SRC['seq'] . ' Accounts');
			$this->t->set_var('TXT_OK', STR_CMMN_OK);
			$this->t->set_var('COLOR_DARK', $dcl_info['DCL_COLOR_DARK']);
			$this->t->set_var('COLOR_LIGHT', $dcl_info['DCL_COLOR_LIGHT']);

			switch ($_SRC['what'])
			{
				case 'dcl_wo_account.wo_id':
					$this->ListFromDb('dcl_wo_account', 'name', 'wo_id = ' . $_SRC['wo_id'] . ' And seq = ' . $_SRC['seq'], 'name');
					break;
				default:
					PrintPermissionDenied();
					return "";
			}

			return $this->t->parse('out', 'hForm');
		}
	}

	function Render()
	{
		echo $this->GetHTML();
	}

	function ListFromDb($table, $valField, $filter = '', $order = '')
	{
		if ($this->oDB == NULL)
		{
			$this->oDB = new dclDB;
			$this->oDB->Connect();
		}

		$sql = "select $valField From $table";
		if ($table == 'dcl_wo_account')
			$sql .= ', accounts';

		if ($filter != '')
		{
			$sql .= ' Where ' . $filter . ' And id = account_id';
		}
		else
			$sql .= ' Where id = account_id';

		if ($order == '')
			$sql .= " Order By $valField";
		else
			$sql .= ' Order By ' . $order;

		$oDB = CreateObject('dcl.dbWorkorders');
		$oDB->Connect();
		$oDB->Query($sql);
		while ($oDB->next_record())
		{
			$this->t->set_var('VAL_TEXT', $oDB->f(0));
			$this->t->parse('hSel', 'sel', true);
		}
	}

	function FrameRender()
	{
		$_SRC = $GLOBALS[GetSourceArray()];
		$this->t = CreateTemplate(array('hForm' => 'htmlWindowListFrame.tpl'));
		$this->t->set_var('LNK_TOP', menuLink('', 'menuAction=htmlWindowList.Top&what=' . $_SRC['what'] . '&wo_id=' . $_SRC['wo_id'] . '&seq=' . $_SRC['seq']));
		$this->t->set_var('LNK_MAIN', menuLink('', 'menuAction=htmlWindowList.Main&what=' . $_SRC['what'] . '&wo_id=' . $_SRC['wo_id'] . '&seq=' . $_SRC['seq']));
		$this->t->pparse('out', 'hForm');
		exit;
	}

	function Top()
	{
		$this->t = CreateTemplate(array('hForm' => 'htmlWindowListTop.tpl'));
		$this->GetHTML('top');
		$this->t->pparse('out', 'hForm');
		exit;
	}

	function Main()
	{
		$this->t = CreateTemplate(array('hForm' => 'htmlWindowListMain.tpl'));
		$this->GetHTML('main');
		$this->t->pparse('out', 'hForm');
		exit;
	}
}
?>
