/*!

\if MANPAGES
\page dcmpsmk Create DICOM grayscale softcopy presentation state
\else
\page dcmpsmk dcmpsmk: Create DICOM grayscale softcopy presentation state
\endif

\section synopsis SYNOPSIS

\verbatim
dcmpsmk [options] dcmfile-in dcmfile-out
\endverbatim

\section description DESCRIPTION

The \b dcmpsmk utility reads a DICOM image file and creates a grayscale
softcopy presentation state object according to Supplement 33.  The
presentation state object is written back to file.  A number of command line
options allow to specify how certain constructs that might be present in
the image file should be referenced or activated in the presentation state.
The newly created presentation state references the source image and
contains values that should allow for a "reasonable" display of the image
when rendered under control of the presentation state.

\section parameters PARAMETERS

\verbatim
dcmfile-in   DICOM image file to be read

dcmfile-out  DICOM presentation state file to be created
\endverbatim

\section options OPTIONS

\subsection general_options general options:
\verbatim
  -h   --help
         print this help text and exit

       --version
         print version information and exit

  -v   --verbose
         verbose mode, print processing details

  -d   --debug
         debug mode, print debug information
\endverbatim

\subsection input_options input optons
\verbatim
input file format:

  +f   --read-file
         read file format or data set (default)

  +fo  --read-file-only
         read file format only

  -f   --read-dataset
         read data set without file meta information

input transfer syntax:

  -t=  --read-xfer-auto
         use TS recognition (default)

  -td  --read-xfer-detect
         ignore TS specified in the file meta header

  -te  --read-xfer-little
         read with explicit VR little endian TS

  -tb  --read-xfer-big
         read with explicit VR big endian TS

  -ti  --read-xfer-implicit
         read with implicit VR little endian TS
\endverbatim

\subsection processing_options processing options
\verbatim
VOI transform handling:

  +Vl  --voi-lut
         use first VOI LUT if present (default)

  +Vw  --voi-window
         use first window center/width if present

  -V   --voi-ignore
         ignore VOI LUT and window center/width

curve handling:

  +c   --curve-activate
         activate curve data if present (default)

  -c   --curve-ignore
         ignore curve data

overlay handling:

  +oc  --overlay-copy
         copy overlays if not embedded, activate otherwise (default)

  +oa  --overlay-activate
         activate overlays

  -o   --overlay-ignore
         ignore overlays

shutter handling:

  +s   --shutter-activate
         use shutter if present in image (default)

  -s   --shutter-ignore
         ignore shutter

presentation LUT shape handling:

  +p   --plut-activate
         use presentation LUT shape if present (default)

  -p   --plut-ignore
         ignore presentation LUT shape

layering:

  +l1  --layer-single
         all curves and overlays are in one layer

  +l2  --layer-double
         one layer for curves, one for overlays (default)

  +ls  --layer-separate
         separate layers for each curve and overlay

location of referenced image:

  -lx  --location-none
         image reference without location (default)

  -ln  --location-network  [a]etitle: string
         image located at application entity a

  -lm  --location-media  [f]ilesetID, fileset[UID]: string
         image located on storage medium
\endverbatim

\subsection output_options output options
\verbatim
output transfer syntax:

  +t=   --write-xfer-same
          write with same TS as image file (default)

  +te   --write-xfer-little
          write with explicit VR little endian TS

  +tb   --write-xfer-big
          write with explicit VR big endian TS

  +ti   --write-xfer-implicit
          write with implicit VR little endian TS
\endverbatim

\section command_line COMMAND LINE

All command line tools use the following notation for parameters: square
brackets enclose optional values (0-1), three trailing dots indicate that
multiple values are allowed (1-n), a combination of both means 0 to n values.

Command line options are distinguished from parameters by a leading '+' or '-'
sign, respectively.  Usually, order and position of command line options are
arbitrary (i.e. they can appear anywhere).  However, if options are mutually
exclusive the rightmost appearance is used.  This behaviour conforms to the
standard evaluation rules of common Unix shells.

In addition, one or more command files can be specified using an '@' sign as a
prefix to the filename (e.g. <em>\@command.txt</em>).  Such a command argument
is replaced by the content of the corresponding text file (multiple
whitespaces are treated as a single separator) prior to any further
evaluation.  Please note that a command file cannot contain another command
file.  This simple but effective approach allows to summarize common
combinations of options/parameters and avoids longish and confusing command
lines (an example is provided in file <em>share/data/dumppat.txt</em>).

\section environment ENVIRONMENT

The \b dcmpsmk utility will attempt to load DICOM data dictionaries specified
in the \e DCMDICTPATH environment variable.  By default, i.e. if the
\e DCMDICTPATH environment variable is not set, the file
<em>\<PREFIX\>/lib/dicom.dic</em> will be loaded unless the dictionary is built
into the application (default for Windows).

The default behaviour should be preferred and the \e DCMDICTPATH environment
variable only used when alternative data dictionaries are required.  The
\e DCMDICTPATH environment variable has the same format as the Unix shell
\e PATH variable in that a colon (":") separates entries.  The data dictionary
code will attempt to load each file specified in the \e DCMDICTPATH
environment variable.  It is an error if no data dictionary can be loaded.

\section copyright COPYRIGHT

Copyright (C) 1998-2005 by Kuratorium OFFIS e.V., Escherweg 2, 26121 Oldenburg,
Germany.

*/
