/* DCTC - a Direct Connect text clone for Linux
 * Copyright (C) 2001 Eric Prevoteau
 *
 * md_crc.h: Copyright (C) Eric Prevoteau <www@a2pb.gotdns.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
/*
$Id: md_crc.h,v 1.2 2003/12/28 08:12:38 uid68112 Exp $
*/

#ifndef __MD_CRC_H__
#define __MD_CRC_H__

/* ed2k splits file in bloc of this size to compute its CRC */
#define PARTSIZE 9728000

/***********************/
/* compute level 0 CRC */
/*************************************************************************/
/* input: adr= where the data to CRC are                                 */
/*        length= size of the data in adr                                */
/* output: if NULL, an error occurs                                      */
/*        else address of a m'allocated buffer of (*l0_crc_length) bytes */
/*************************************************************************/
guint8 *l0_crc(unsigned char *adr, size_t length, unsigned int *l0_crc_length);

/*******************************************/
/* check if the given file has a valid CRC */
/********************************************************/
/* input: filename= name of a file to compare           */
/*        crc_to_compare= an array of MD4_DIGEST_LENGTH */
/*                   bytes containing the CRC to verify */
/********************************************************/
/* output: 0= CRC is valid    */
/*         1= CRC is invalid  */
/*         2= an error occurs */
/******************************/
int is_a_file_with_a_valid_crc(const char *filename, guint8 *crc_to_compare);

/******************************/
/* compute the CRCs of a file */
/********************************************************/
/* input: filename= name of a file to compare           */
/*        g_crc=an array of MD4_DIGEST_LENGTH bytes     */
/********************************************************/
/* output: 0= CRC is valid                             */
/*         2= an error occurs                          */
/* on success, *l0_md is allocated and contains L0 CRC */
/* and *length is set to the file size                 */
/*******************************************************/
int compute_file_crcs(const char *filename, guint8 *g_crc, guint8 **l0_md, size_t *length);

/**************************************************************************/
/* convert a MD_BLOC_SIZE ID from its ascii version to its binary version */
/**************************************************************************/
void id_ascii_to_bin(unsigned char *asc_id, guint8 *bin_id);

/*************************************************************/
/* append the ASCII version of MD4 CRC to the given g_string */
/*************************************************************/
void append_MD4_to_str(GString *dest_base, guint8 *id);

#endif
