/* DCTC - a Direct Connect text clone for Linux
 * Copyright (C) 2001 Eric Prevoteau
 *
 * dh.h: Copyright (C) Eric Prevoteau <www@a2pb.gotdns.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
/*
$Id: mydb.h,v 1.2 2003/12/28 08:12:38 uid68112 Exp $
*/

#ifndef __DB_H__
#define __DB_H__

#include "md.h"
 
/* directory containing virtual shares */
extern char *vshare_directory;

/*****************************************************/
/* add a directory to the list of shared directories */
/**********************************************************/
/* due to the fact this function runs in the main thread, */
/* it is not possible to be locked forever, even if there */
/* is lot of $Search request because they also are run    */
/* from this thread (at least at the beginning)           */
/**********************************************************/
void add_shared_directory(char *dir);

/********************************************************/
/* remove a directory to the list of shared directories */
/**********************************************************/
/* due to the fact this function runs in the main thread, */
/* it is not possible to be locked forever, even if there */
/* is lot of $Search request because they also are run    */
/* from this thread (at least at the beginning)           */
/**********************************************************/
void remove_shared_directory(char *dir);

/***********************************/
/* set the virtual share directory */
/***********************************/
void set_vshare_directory(char *dir);

/******************************************************************************/
/* get the list of all shared directories. Each directory is separated by a | */
/******************************************************************************/
/* output: GString containing the list of directories. Must be freed */
/*********************************************************************/
GString *get_shared_directory_list(void);

/***************************************************************/
/* fully rebuild shared file database                          */
/* this rebuilding can be done even if a search is in progress */
/***************************************************************/
void rebuild_database(void);

/*******************************************************/
/* description of an entry in the shared file database */
/*******************************************************/
typedef struct
{  
	int filetype;                       /* 2=audio,3=compressed,4=document,5=exe,6=picture,7=videos,8=folder */
	int virtual;								/* 0=file is real, 1=file is virtual */
	unsigned long filesize;             /* in bytes */
	char *filename;                     /* filename with full path */
	unsigned char md5sum[MD5SUMLEN];		/* md5sum of the file */
} DB_ENTRY;

/* type of size usable to perform a search */
typedef enum
{
	SA_NO_MATTER=0,
	SA_AT_LEAST,
	SA_AT_MOST
} SIZE_ATTRIB;

/***************************************************************************/
/* search a pattern inside database and send results into the given socket */
/*******************************************************************************/
/* input: sck= socket where results should be written                          */
/*        dest_nick= nickname of the destination user (can be NULL)            */
/*        size_matter= 0:no size requirement, 1:size at least, 2: size at most */
/*        size: if size_matter, it is the required size.                       */
/*        pattern: one or more words separated by space.                       */
/*        md5sum= md5sum to match with (md5sum can be null)                    */
/*        dest_addr: address to send result (active mode), can be NULL (=passiv*/
/*                (if dest_nick==NULL, dest_addr is the destination)           */
/*                (if dest_addr==NULL, dest_nick is the destination)           */
/*******************************************************************************/
void search_in_db(int sck, char *dest_nick, int file_type, SIZE_ATTRIB size_matter, unsigned long size, char *pattern, unsigned char *md5sum, struct sockaddr_in *dest_addr);

/*************************************************************/
/* check if the given filename exists in the shared database */
/*************************************************************/
/* output: 0=no, 1=yes                                   */
/* if yes, *virtual ==1 if the file is virtual else == 0 */
/*********************************************************/
int file_in_db(char *filename, int *virtual);

G_LOCK_EXTERN(shared_info);

/********************************************************************/
/* it is the same info as shared_info except                        */
/* it is in "/LS" format and already compressed using HE3 algorithm */
/* This data are sent when a remote user does a $GetDirList to      */
/* retrieve the list of files shared by this client.                */
/********************************************************************/
extern GByteArray *he3_ls_info;    /* protected by shared_info lock */

/*******************************************************************************************/
/* search a file having given md4 CRC (MD4_DIGEST_LENGTH bytes) with the given file_length */
/* in the MD DB and if not found, search inside the shared file db                         */
/*******************************************************************************************/
void find_file_with_crc_and_length_and_reply(int output_sck, const char *searching_nick, const guint8 *md4, guint32 file_length);

#endif
