/* DCTC - a Direct Connect text clone for Linux
 * Copyright (C) 2001 Eric Prevoteau
 *
 * hfactory.c: Copyright (C) Eric Prevoteau <www@ac2i.tzo.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
/*
$Id: hfactory.c,v 1.1 2003/05/31 13:20:56 ericprev Exp $
*/

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <stdio.h>
#include <string.h>
#include <glib.h>

#include "factory.h"
#include "hfactory.h"
#include "packet_define.h"

/*********************************************/
/* set of functions to build typical packets */
/*********************************************/

/*******************************************************/
/* build the hello packet sent by a client to a server */
/*******************************************************/
GByteArray *hf_hello_server(guint8 client_hash[16], guint32 client_ip, guint16 client_port)
{
	PACKET_BUILD *pb;

	pb=ed2k_pb_new();
	ed2k_pb_add_byte(pb,0xE3);			/* edonkey packet type */
	ed2k_pb_set_size_location(pb);
	ed2k_pb_set_size_begin_location(pb);

	/* now, add the content of the packet */
	ed2k_pb_add_byte(pb,CS_HELLO_ID);
	ed2k_pb_add_bytes(pb,client_hash,16);
	ed2k_pb_add_lsb_4bytes(pb,client_ip);
	ed2k_pb_add_lsb_2bytes(pb,client_port);
	ed2k_pb_add_lsb_4bytes(pb,0);			/* no meta tag list */

	ed2k_pb_set_size_end_location(pb);
	return ed2k_pb_end(pb);
}

/***********************************/
/* build the search by hash packet */
/***********************************/
GByteArray *hf_get_sources_from_hash(guint8 file_hash[16])
{
	PACKET_BUILD *pb;

	pb=ed2k_pb_new();
	ed2k_pb_add_byte(pb,0xE3);			/* edonkey packet type */
	ed2k_pb_set_size_location(pb);
	ed2k_pb_set_size_begin_location(pb);

	/* now, add the content of the packet */
	ed2k_pb_add_byte(pb,CS_GET_SOURCES);
	ed2k_pb_add_bytes(pb,file_hash,16);
		
	ed2k_pb_set_size_end_location(pb);
	return ed2k_pb_end(pb);
}
