##########################################################################
#
# __init__.py:  defines this directory as the 'tests' package.
#
#  Debian Partial Mirror is a tool to make complete and partial Debian mirrors.
#  See http://projetos.ossystems.com.br/debpartial-mirror/ for more information.
#    
# ====================================================================
# Copyright (c) 2002-2005 O.S. Systems.  All rights reserved.
#
# This software is licensed as described in the file COPYING, which
# you should have received as part of this distribution.
#
#########################################################################
# Author: Otavio Salvador <otavio@ossystems.com.br>

from unittest import TestCase
from os.path  import abspath, join, dirname

import sys

class TestBase(TestCase):
	def aux_file(self, filename):
		current_dir = abspath(dirname(sys.argv[0]))

		if not current_dir.endswith('tests'):
			current_dir += '/tests'

		return join(current_dir, 'aux', filename)
