
#ifndef DEF_H
#define DEF_H

#define _GNU_SOURCE

#define PROG           "debram"
#define VERSION        "1.0.2"

#define DATA_FILE_BASENAME \
  "debram.txt"
#ifdef  DEBRAM_LOCAL
  #define DATA_FILE                        DATA_FILE_BASENAME
#else
  #define DATA_FILE "/usr/share/" PROG "/" DATA_FILE_BASENAME
#endif
#define DATA_FILE_GZ   DATA_FILE ".gz"

#define N_DIG             4 /* no of digits in a ram number */
#define N_DIG_STR      "four" /* should reflect N_DIG above */

#define TTY_WIDTH1     0x50
#define TTY_WIDTH1_STR  "80"
#define TTY_WIDTH2     0x84
#define TTY_WIDTH2_STR "132"
#define WIDTH_DATA     TTY_WIDTH2

#define WIDTH_MAINT     0xf
#define WIDTH_PRI         3
#define WIDTH_DEB      0x1c
#define SHIFTWIDTH        2 /* the toc indent increment */
#define NMAX_XREF       0xd

#define CHARFMT_LATIN1 "LATIN1"
#define CHARFMT_UTF8   "UTF8"
#define SIZE_UTF8         6 /* the max no of bytes in a utf-8 char */
#define SIZE_UTF8_RING    3 /* how many utf-8 buffers available */

#define INDIC_XREF     "--->"

#define DEBUG_LOCALE      0

#endif

