#!/usr/bin/env python
# -*- coding: utf-8 -*-
#
# Author: Ingelrest François (Athropos@gmail.com)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Library General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA

import gobject, gtk.glade, os.path, tools

from tools import consts, prefs


PREFS_DEFAULT_PANED_POS  = 220
PREFS_DEFAULT_WIN_WIDTH  = 750
PREFS_DEFAULT_WIN_HEIGHT = 430


def onResize(win, rect):
    """ Save the new size of the window """
    prefs.set(__name__, 'win-width',  rect.width)
    prefs.set(__name__, 'win-height', rect.height)


def startup():
    """
        Perform all the initialization stuff which is not mandatory to display the window
        This function should be called within the GTK main loop, once the window has been displayed
        This allows to display the window ASAP, so that the user has a better feedback
    """
    import gettext, modules, locale, webbrowser

    from gui import about, preferences

    # Localization
    locale.setlocale(locale.LC_ALL, '')
    gettext.textdomain(consts.appNameShort)
    gettext.bindtextdomain(consts.appNameShort, consts.dirLocale)
    gtk.glade.textdomain(consts.appNameShort)
    gtk.glade.bindtextdomain(consts.appNameShort, consts.dirLocale)

    # GTK handlers
    window.connect('destroy', lambda win: modules.postQuitMsg())
    window.connect('size-allocate', onResize)
    paned.connect('size-allocate', lambda win, rect: prefs.set(__name__, 'paned-pos', paned.get_position()))
    wTree.get_widget('menu-quit').connect('activate', lambda win: modules.postQuitMsg())
    wTree.get_widget('menu-about').connect('activate', lambda win: about.show(window))
    wTree.get_widget('menu-help').connect('activate', lambda win: webbrowser.open(consts.urlHelp))
    wTree.get_widget('menu-preferences').connect('activate', lambda win: preferences.show())

    # Load modules
    modules.initialLoad(wTree)
    modules.postMsg(modules.MSG_EVT_APP_STARTED)


# --== Entry point ==--

gtk.window_set_default_icon(gtk.gdk.pixbuf_new_from_file(consts.fileImgIcon))
gobject.threads_init()

# Create the GUI
wTree  = tools.loadGladeFile('MainWindow.glade')
paned  = wTree.get_widget('pan-main')
window = wTree.get_widget('win-main')

# Restore the previous state
window.resize(prefs.get(__name__, 'win-width', PREFS_DEFAULT_WIN_WIDTH), prefs.get(__name__, 'win-height', PREFS_DEFAULT_WIN_HEIGHT))
paned.set_position(prefs.get(__name__, 'paned-pos', PREFS_DEFAULT_PANED_POS))

# Show the window
window.show_all()
gobject.idle_add(startup)
gtk.main()
