# -*- coding: utf-8 -*-
#
# Author: Ingelrest François (Athropos@gmail.com)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Library General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA

import gtk

from tools import consts


def __msgBox(parent, msgType, buttons, primaryText, secondaryTxt):
    """ Show a generic message box """
    dlg = gtk.MessageDialog(parent, gtk.DIALOG_MODAL, msgType, buttons, primaryText)
    dlg.set_title(consts.appName)

    if secondaryTxt is None: dlg.set_markup(primaryText)
    else:                    dlg.format_secondary_markup(secondaryTxt)

    response = dlg.run()
    dlg.destroy()
    return response


def errorMsgBox(parent, primaryText, secondaryTxt=None):
    """ Show an error message box """
    __msgBox(parent, gtk.MESSAGE_ERROR, gtk.BUTTONS_OK, primaryText, secondaryTxt)


def questionMsgBox(parent, primaryText, secondaryTxt=None):
    """ Ask a question to the user """
    return __msgBox(parent, gtk.MESSAGE_QUESTION, gtk.BUTTONS_YES_NO, primaryText, secondaryTxt)


def infoMsgBox(parent, primaryText, secondaryTxt=None):
    """ Show an information message box """
    __msgBox(parent, gtk.MESSAGE_INFO, gtk.BUTTONS_OK, primaryText, secondaryTxt)
