# -*- coding: utf-8 -*-
#
# Author: Ingelrest François (Athropos@gmail.com)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Library General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA

import modules, os.path

from tools   import consts
from media   import playlist
from modules import ThreadedModule
from gettext import gettext as _


# TODO
# This module should better manage startup: the user may want to open files from his file explorer, it's not possible for the moment since this
#  module will always replace the tracklist content by the last tracklist
# MOD_NAME            = _('Auto Restore Playlist')
# MOD_DESC            = _('Restore the last playlist upon starting')
# MOD_IS_MANDATORY    = False
# MOD_IS_CONFIGURABLE = False


class RestoreTracklist(ThreadedModule):


    def __init__(self, wTree):
        """ Constructor """
        ThreadedModule.__init__(self)
        self.filename = os.path.join(consts.dirCfg, 'saved-playlist.m3u')
        modules.register(self, [modules.MSG_EVT_NEW_TRACKLIST, modules.MSG_EVT_APP_STARTED])


    # --== Message handler ==--


    def handleMsg(self, msg, params):
        """ Handle messages sent to this modules """
        if   msg == modules.MSG_EVT_NEW_TRACKLIST: playlist.save(params['files'], self.filename)
        elif msg == modules.MSG_EVT_APP_STARTED:   modules.postMsg(modules.MSG_CMD_TRACKLIST_SET, {'files': [self.filename], 'playNow': False})
