# -*- coding: utf-8 -*-
#
# Author: Ingelrest François (Athropos@gmail.com)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Library General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA

import cPickle, os

from tools     import consts
from threading import Lock


mPrefs = {}       # All preferences
mMutex = Lock()   # Prevent concurrent access to the functions


if os.access(consts.filePrefs, os.F_OK):
    inFile = open(consts.filePrefs, 'r')
    try:    mPrefs = cPickle.load(inFile)
    except: mPrefs = {}
    inFile.close()


def save():
    """ Save preferences to the disk """
    mMutex.acquire()
    outFile = open(consts.filePrefs, 'w')
    cPickle.dump(mPrefs, outFile)
    outFile.close()
    os.chmod(consts.filePrefs, 0600)
    mMutex.release()


def set(modName, prefName, prefValue):
    """ Change the value of a preference """
    mMutex.acquire()
    mPrefs['%s_%s' % (modName, prefName)] = prefValue;
    mMutex.release()


def get(modName, prefName, default=None):
    """ Retrieve the value of a preference """
    name = '%s_%s' % (modName, prefName)
    mMutex.acquire()
    if mPrefs.has_key(name): prefValue = mPrefs[name]
    else:                    prefValue = default
    mMutex.release()
    return prefValue
