/*
 * the Decibel Realtime Communication Framework
 * Copyright (C) 2006 by basyskom GmbH
 *  @author Tobias Hunger <info@basyskom.de>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef _DECIBEL_DAEMON_CONTACTMANAGER_H_
#define _DECIBEL_DAEMON_CONTACTMANAGER_H_

#include <QtCore/QObject>

#include <Decibel/Types>

#include <QtTapioca/ContactBase>

namespace QtTapioca
{
class Connection;
}

class AccountManager;
class ContactManagerPrivate;

/** The ContactManager is a class interfacing to the desktop environment's
  *  contact data.
  */
class ContactManager : public QObject
{
    Q_OBJECT
    Q_DECLARE_PRIVATE(ContactManager)

public:
    /** Constructor. */
    explicit ContactManager(AccountManager *, QObject * parent = 0);
    /** Destructor */
    ~ContactManager();

public slots:
    /**
     * @brief Connect to a contact using a given account.
     * @param contact_id The Id of the contact to connect to.
     * @param account_handle A handle to the account to use.
     * @param type The type of connection requested.
     * @param suppress_handler
     * @returns A channel info object describing the channel set up.
     *
     * This is the basic connection method: It sets up a communication channel
     * between the account and the contact if possible and returns it to the
     */
    Decibel::ChannelInfo
    contactContactUsingAccount(const uint contact_id, const int account_handle,
                               const int type, const bool suppress_handler);

private slots:
    void onConnectionOpened(QtTapioca::Connection *);
    void onConnectionClosed(QtTapioca::Connection *);
    void onPresenceUpdated(QtTapioca::ContactBase *,
                           QtTapioca::ContactBase::Presence,
                           const QString &);

private:
    ContactManagerPrivate * const d;
};

#endif
