#! /bin/sh
## dpkg-dep.sh - example script that uses dep.pl
## Copyright (C) 1999, 2000 The MadHouse Project
##
## This file is part of dep.pl.
##
## dep.pl is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published by
## the Free Software Foundation; either version 2 of the License, or
## (at your option) any later version.
##
## dep.pl is distributed in the hope that it will be useful,
## but WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
## GNU General Public License for more details.
##
## You should have received a copy of the GNU General Public License
## along with this program; if not, write to the Free Software
## Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
##
## $Id: dpkg-dep.sh,v 1.11 2000/12/12 15:55:15 algernon Exp $

VERSION=`echo "$Revision: 1.11 $ :" | sed -e 's,^.*: \([^ ]*\).*,\1,' -e s,^.*:,,`

########################
# GET PARAMATERS       #
########################
OPTS="-bq"

for ARG;
do
	case $ARG in
		"-Q") QUIET="1" ;;
		"-H") HELP="1" ;;
		*) OPTS="$OPTS $ARG" ;;
	esac
done

########################
# DISPLAY BANNER       #
########################

if test "$QUIET" != "1" -o "$OPTS" = "-bq" -o "$HELP" = "1"; then
	echo
	echo "dpkg-dep.sh $VERSION (C) 1999-2000 The MadHouse Project ="
	echo "====================================================="
	echo
fi

if test "$HELP" = "1"; then
	echo "Usage: dpkg-dep.sh [OPTIONS] files..."
	echo
	echo "Options:"
	echo "	-Q	: Quiet operation."
	echo "	-H	: This help screen."
	echo
	echo "And of course, any options that dep.pl understands..."
	echo
	exit 0
fi

if test "$OPTS" = "-bq"; then
	echo "I need some filenames..."
	echo
	exit 1
fi

########################
# RUN dep.pl           #
########################

if test "$QUIET" != "1"; then
	echo -n "Running dep.pl ..."
fi

LIBS=`dep.pl $OPTS`

if test "$QUIET" != "1"; then
	echo " done."
fi

########################
# PASS RESULTS TO DPKG #
########################
DPKG_OPTS="--search $LIBS";

if test "$LIBS" != ""; then

	if test "$QUIET" != "1"; then
		echo "Running dpkg ..."
	fi

	dpkg $DPKG_OPTS
fi
