/**************************************************************
  (C) 1997 by Achim Kaiser

  You may distribute under the terms of the GNU General Public
  License as specified in the COPYING file.
**************************************************************/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "timer.h"
#include "global.h"
#include "iwc.h"
#include <stdlib.h>
#include <string.h>
#include <sys/stat.h>

#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif

#include <sys/signal.h>
#include <time.h>

void destroy()
{
  XCloseDisplay(GetDisplay());
  _exit(0);
}

void updatetimer()
{
  static time_t lastmodificationtime=0;
  char *pathsaved;
  struct stat info2;

  signal(SIGALRM,updatetimer);
  alarm(GetTimer());
  
  if (GetKindOfWindow()==STRUCTURE) {
    pathsaved=strdup(GetPath());
    if (pathsaved[0]=='~' && pathsaved[1]=='/')
      pathsaved[0]='.';
    stat(pathsaved,&info2);
    free(pathsaved);
    if (lastmodificationtime<info2.st_mtime) {
      lastmodificationtime=info2.st_mtime;
      SendWindow(GetMoveWindow(),UPDATE_LIGHT);
    }
  } else {
    SendWindow(GetMoveWindow(),UPDATE_LIGHT);
  }
}

void repeat()
{
  signal(SIGALRM,repeat);
  alarm(GetTimer());
}

void StopAlarm()
{
  alarm(0);
}

void ReactivateAlarm()
{
  signal(SIGALRM,repeat);
  alarm(GetTimer());
}

void SetDestroy(int sec)
{
  signal(SIGALRM,destroy);
  alarm(sec);
}

void StopDestroy()
{
  signal(SIGALRM,repeat);
}
