/* dia-clock.h
 * Copyright (C) 2001  Arjan Molenaar
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
/*
 * DiaClock
 * ----------
 * A nice demonstration of a somewhat more complex object: a clock.
 */

#ifndef __DIA_CLOCK_H__
#define __DIA_CLOCK_H__

#include <diacanvas/dia-canvas-element.h>
#include <time.h>

G_BEGIN_DECLS

#define DIA_TYPE_CLOCK        (dia_clock_get_type ())
#define DIA_CLOCK(obj)		(G_TYPE_CHECK_INSTANCE_CAST ((obj), DIA_TYPE_CLOCK, DiaClock))
#define DIA_CLOCK_CLASS(klass)	(G_TYPE_CHECK_CLASS_CAST ((klass), DIA_TYPE_CLOCK, DiaClockClass))
#define DIA_IS_CLOCK(obj)		(G_TYPE_CHECK_INSTANCE_TYPE ((obj), DIA_TYPE_CLOCK))
#define DIA_IS_CLOCK_CLASS(klass)	(G_TYPE_CHECK_CLASS_TYPE ((klass), DIA_TYPE_CLOCK))
#define DIA_CLOCK_GET_CLASS(obj)	(G_TYPE_INSTANCE_GET_CLASS ((obj), DIA_TYPE_CLOCK, DiaClockClass))

typedef struct _DiaClock DiaClock;
typedef struct _DiaClockClass DiaClockClass;

struct _DiaClock
{
	DiaCanvasElement item;

	glong sec;

	guint timer;

	DiaShape *circle, *hours, *minutes, *seconds;
};


struct _DiaClockClass
{
	DiaCanvasElementClass parent_class;
};

GType dia_clock_get_type (void);

	
G_END_DECLS


#endif /* __DIA_CLOCK_H__ */
