/*
 * Tests undo functions.
 */

#include <diacanvas/dia-undo.h>
#include "unit-test.h"

typedef struct _UndoData UndoData;

struct _UndoData
{
	DiaUndoAction entry;

	gint *p; /* pointer to an int */
	gint data;
	gint redo_data;
};

void
undo_data_undo (DiaUndoAction *e)
{
	UndoData *d = (UndoData*) e;

	//dia_undo_manager_add_undo_action (current value in entry)
	d->redo_data = *d->p;
	*d->p = d->data;
}

void
undo_data_redo (DiaUndoAction *e)
{
	UndoData *d = (UndoData*) e;

	//dia_undo_manager_add_undo_action (current value in entry)
	g_message(G_STRLOC": redo");
	*d->p = d->redo_data;
}

void
undo_data_destroy (gpointer e)
{
}

DiaUndoAction*
undo_data_new(gint *data)
{
	UndoData *d = (UndoData*) dia_undo_action_new (sizeof (UndoData),
						 undo_data_undo,
						 undo_data_redo,
						 undo_data_destroy);

	d->p = data;
	d->data = *data;

	return (DiaUndoAction*) d;
}

DiaUndo *undo;

void
setup (void)
{
	undo = g_object_new(dia_undo_get_type(), NULL);
}

void
teardown (void)
{
	g_object_unref (undo);
	undo = NULL;
}

TEST_BEGIN (DiaUndo, setup, teardown)

TEST_NEW (test_undo_1)
{
	int x = 5;

	dia_undo_manager_begin_transaction(DIA_UNDO_MANAGER (undo));
	dia_undo_manager_add_undo_action (DIA_UNDO_MANAGER (undo),
					 undo_data_new (&x));
	dia_undo_manager_commit_transaction (DIA_UNDO_MANAGER (undo));
	TEST (dia_undo_manager_can_undo (DIA_UNDO_MANAGER (undo)));

	x = 6;

	dia_undo_manager_undo_transaction (DIA_UNDO_MANAGER (undo));
	TEST (!dia_undo_manager_can_undo (DIA_UNDO_MANAGER (undo)));
	TEST (dia_undo_manager_can_redo (DIA_UNDO_MANAGER (undo)));

	TEST (x == 5);

	dia_undo_manager_redo_transaction (DIA_UNDO_MANAGER (undo));
	TEST (dia_undo_manager_can_undo (DIA_UNDO_MANAGER (undo)));
	TEST (!dia_undo_manager_can_redo (DIA_UNDO_MANAGER (undo)));

	TEST (x == 6);

	dia_undo_manager_undo_transaction (DIA_UNDO_MANAGER (undo));
	TEST (!dia_undo_manager_can_undo (DIA_UNDO_MANAGER (undo)));
	TEST (dia_undo_manager_can_redo (DIA_UNDO_MANAGER (undo)));

	TEST (x == 5);
}

TEST_NEW (test_undo_2)
{
	int x = 5;

	dia_undo_manager_begin_transaction(DIA_UNDO_MANAGER (undo));
	dia_undo_manager_add_undo_action (DIA_UNDO_MANAGER (undo),
					 undo_data_new (&x));
	x = 7;

	dia_undo_manager_add_undo_action (DIA_UNDO_MANAGER (undo),
					 undo_data_new (&x));
	dia_undo_manager_commit_transaction (DIA_UNDO_MANAGER (undo));
	TEST (dia_undo_manager_can_undo (DIA_UNDO_MANAGER (undo)));

	x = 6;

	dia_undo_manager_undo_transaction (DIA_UNDO_MANAGER (undo));
	TEST (!dia_undo_manager_can_undo (DIA_UNDO_MANAGER (undo)));
	TEST (dia_undo_manager_can_redo (DIA_UNDO_MANAGER (undo)));

	TEST (x == 5);

	dia_undo_manager_redo_transaction (DIA_UNDO_MANAGER (undo));
	TEST (dia_undo_manager_can_undo (DIA_UNDO_MANAGER (undo)));
	TEST (!dia_undo_manager_can_redo (DIA_UNDO_MANAGER (undo)));

	TEST (x == 6);
}

TEST_END ()
