/*
    digitools.c - A user-space program to handle the ASUS DigiMatrix
                  special capabilities.
    Copyright (c) 2006 Andrew Calkin <calkina@geexbox.org> and
                       Ben Potter <linux@bpuk.org>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <getopt.h>
#include <unistd.h>
#include <sys/types.h>
#include <signal.h>
#include "digitools.h"
#include "digipanel.h"
#include "digifan.h"
#include "digiwake.h"
#include "oz263.h"
#include "ozedit.h"

LED led = LED_NONE;
PP pp = PP_NONE;
DOTS dots = DOTS_NONE;
char digits[7];
int file=0;
char *prog;

void daemon_init(void)
{
  pid_t pid_number;

  extern char *prog;

  char prog_full_name[20];
  char * prog_name=prog_full_name;
  strncpy(prog_full_name,prog,sizeof(prog_full_name));
  while (strstr(prog_name,"/"))
    prog_name=strstr(prog_name,"/")+1;

  char pid_file_name[20]="/tmp/";
  strcat(strcat(pid_file_name,prog_name),".pid");
  FILE * fpid;

  pid_number=fork();

  if (pid_number < 0)
  {
#ifndef SILENT
    fprintf(stderr,"Error: Could not fork() daemon!\n");
#endif
    exit(1);
  }
  else if (pid_number > 0)
  { /* parent */
    fpid=fopen(pid_file_name,"w");
    if (fpid == NULL)
    {
#ifndef SILENT
      fprintf(stderr,"Error:Could not open %s for "
                     "writing!\n",pid_file_name);
#endif
      exit(1);
    }
    fprintf(fpid,"%d",pid_number);
    fclose(fpid);
    exit(0);
  }
}

void daemon_kill(void)
{
  extern char *prog;

  FILE * fproc;
  char procfile_name[20]="/proc/";
  char proc_contents[20];

  char prog_full_name[20];
  char * prog_name=prog_full_name;
  strncpy(prog_full_name,prog,sizeof(prog_full_name));
  while (strstr(prog_name,"/"))
    prog_name=strstr(prog_name,"/")+1;

  char pid_file_name[20]="/tmp/";
  strcat(strcat(pid_file_name,prog_name),".pid");
  FILE * fpid;

  char pid_read[20];

  fpid=fopen(pid_file_name,"r");
  if (fpid)
  {
    fgets(pid_read,20,fpid);
    fclose(fpid);

    strcat(strcat(procfile_name,pid_read),"/stat");
    fproc=fopen(procfile_name,"r");
    if (fproc)
    {
      fgets(proc_contents,sizeof(proc_contents),fproc);
      fclose(fproc);

      if (strstr(proc_contents, prog_name)!=NULL)
        kill(atoi(pid_read),SIGTERM);

      remove(pid_file_name);
    }
  }
}

int main (int argc, char **argv)
{
  prog=argv[0];

  if (strstr (argv[0], "digiradio"))
    return digiradio_main(argc, argv);
  if (strstr (argv[0], "setradio"))
    return digiradio_main(argc, argv);
  else if (strstr (argv[0], "digipanel"))
    return digipanel_main(argc, argv);
  else if (strstr (argv[0], "setpanel"))
    return digipanel_main(argc, argv);
  else if (strstr (argv[0], "digifan"))
    return digifan_main(argc, argv);
  else if (strstr (argv[0], "asusfan"))
    return digifan_main(argc, argv);
  else if (strstr (argv[0], "digiwake"))
    return digiwake_main(argc, argv);
  else if (strstr (argv[0], "ozedit"))
    return ozedit_main(argc, argv);
  else
  {
#ifndef SILENT
    fprintf(stderr,"Unknown program name!\n");
#endif
    return -1;
  }
}
