/*
 * Decompiled with CFR 0.152.
 */
package de.xeinfach.kafenio;

import de.xeinfach.kafenio.KafenioApplet;
import de.xeinfach.kafenio.util.LeanLogger;
import java.util.HashMap;
import java.util.Iterator;

public final class KafenioAppletObserver {
    private static LeanLogger log = new LeanLogger("KafenioAppletObserver.class");
    private static KafenioAppletObserver instance = null;
    private static HashMap applets = new HashMap();

    private KafenioAppletObserver() {
    }

    public static synchronized KafenioAppletObserver getInstance() {
        if (instance == null) {
            instance = new KafenioAppletObserver();
        }
        return instance;
    }

    public synchronized void registerNewApplet(KafenioApplet kafenioApplet) {
        applets.put(kafenioApplet.getName(), kafenioApplet);
        log.info("register: current number of applets: " + applets.size());
    }

    public synchronized void unregisterApplet(KafenioApplet kafenioApplet) {
        applets.remove(kafenioApplet.getName());
        log.info("unregister: current number of applets: " + applets.size());
    }

    public synchronized void saveAllAppletContents() {
        log.debug("Saving Content in " + applets.size() + " applets.");
        Iterator iterator = applets.values().iterator();
        while (iterator.hasNext()) {
            KafenioApplet kafenioApplet = (KafenioApplet)iterator.next();
            kafenioApplet.saveAppletContents();
        }
    }
}

