#ifndef _CDLIST_H_INCLUDED
#define _CDLIST_H_INCLUDED

#include "config.h"
#ifdef HAVE_LIBCDDA_PARANOIA

#include <qwidget.h>
#include "list.h"

class QListView;
class QListViewItem;
class QPixmap;
class Playlist;

class CDList : public List
{
Q_OBJECT
public:
	CDList(QWidget *parent, Playlist *pl, const char *name = 0, WFlags f = 0);
	virtual ~CDList();
	virtual void setDir(QString i_dir);
	virtual void setFile(QString i_file);
	virtual QString getDir();
	virtual QString getTitle();
	virtual void setTitle(QString title);
	virtual QString getSelectedFile();
	virtual void addFile(QString file, bool save=true);
	QListView *lv;
protected:
	QString dir;
	QPixmap *p_dir, *p_file, *p_up;
	QString tab_name;
	virtual void load();
	Playlist *pl;
protected slots:
	virtual void resizeEvent(QResizeEvent *e);
	virtual void lv_doubleClicked(QListViewItem *it);
	virtual void lv_rightClicked(QListViewItem *it, const QPoint& pos, int col);
	virtual void moveToList(int arg);
};

#endif /* HAVE_LIBCDDA_PARANOIA */
#endif
