#include "bitmapsliderplugin.h"
#include "bitmapslider.h"
#include "bitmapslider.xpm"

BitmapSliderPlugin::BitmapSliderPlugin()
{
}

QStringList BitmapSliderPlugin::keys() const
{
	QStringList list;
	list << "BitmapSlider";
	return list;
}

QWidget *BitmapSliderPlugin::create(const QString& key, QWidget *parent, const char *name)
{
	if(key == "BitmapSlider")
		return new BitmapSlider(parent, name);
	return 0;
}

QString BitmapSliderPlugin::includeFile( const QString& feature ) const
{
	if(feature == "BitmapSlider")
		return "bitmapslider.h";
	return QString::null;
}

QString BitmapSliderPlugin::group( const QString& feature ) const
{
	if(feature == "BitmapSlider")
		return "Input";
	return QString::null;
}

QIconSet BitmapSliderPlugin::iconSet( const QString& ) const
{
	return QIconSet(QPixmap((const char **)bitmapslider_xpm));
}

QString BitmapSliderPlugin::toolTip( const QString& feature ) const
{
	if(feature == "BitmapSlider")
		return "Bitmap Slider";
	return QString::null;
}

QString BitmapSliderPlugin::whatsThis( const QString& feature ) const
{
	if(feature == "BitmapSlider")
		return "A slider using bitmap images draw itself";
	return QString::null;
}

bool BitmapSliderPlugin::isContainer( const QString& ) const
{
	return false;
}

Q_EXPORT_PLUGIN(BitmapSliderPlugin)
