/*
 *  DNAS module tester / load and write out the file to stdout
 *  Copyright (C) 2002 Junichi Uekawa
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *$Id: test-loadwrite.c,v 1.2 2002/11/13 14:31:18 dancer Exp $
 */

/* load-write test. to check that things are working. */

#include <stdio.h>
#include <stdlib.h>

#include "dmachinemon/dmachinemon.h"


void 
write_contents(dm_pairstring * s)
{
  if(s)
    {
      write_contents(s->next);
      printf("%s: %s\n", s->stringtitle, s->stringdata);
    }
  
}

void
write_machine(dm_machinelist * m)
{
  if (m)
    {
      write_machine(m->next);
      printf(":%s:\n", m->machinename);
      write_contents(m->data);
    }
}



int
main(int ac, char ** av)
{
  if (av[1])
    {
      FILE*f = fopen (av[1], "r");
      if (!f) exit (EXIT_FAILURE);
      dm_process_nodes_input (f, &maininfo, NULL, NULL);
      write_machine (maininfo.machinedb);

      fclose(f);
    }
  else
    {
      fprintf(stderr, "please specify parameter, filename count \n");
      exit (EXIT_FAILURE);
    }
  exit (EXIT_SUCCESS);
  
}
