/*
 *  Remote Network application system for DNAS -- plugin for text display
 *  Copyright (C) 2002 Junichi Uekawa
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * $Id: rnasmonitor-singlepoint.c,v 1.7 2002/11/17 14:25:24 dancer Exp $
 */

#define _GNU_SOURCE
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <unistd.h>
#include <pthread.h>
#include <gdk/gdk.h>
#include <gtk/gtk.h>
#include <pthread.h>
#include <locale.h>
#include "config.h"
#include "dmachinemon/dmachinemon-debug.h"
#include "dmachinemon/dmachinemon.h"
#include "dmachinemon/libsocket.h"
#include "dmachinemon/dmachinemon-libdatabase.h"
#include "dmachinemon/dmachinemon-commandlineparser.h"
#include "rnas-monitor-gtk.h"

#define DRAW_AREA_WIDTH 64
#define DRAW_AREA_HEIGHT 64
#define PIX_WIDTH 64
#define PIX_HEIGHT 64

#define ICON_WIDTH 16
#define ICON_HEIGHT 16
typedef struct 
{
  float minx, miny, maxx, maxy;
  const char * tagx, *tagy;
}ApplicationData;

typedef struct 
{
  GdkPixmap* g_pixmap;		/* the main screen image. 
					   can be used as GdkDrawable
					*/
  GdkGC * g_gc;			/* Drawing context */
  GdkPixmap* my_icon;		/* current icon */
  GdkBitmap* my_icon_shape;		/* current icon shape */
  GtkWidget * drawingarea;	/* the drawing area */
}perwindow_data;



int
rnas_monitor_initialize (rnasmonitors * r)
{
  ApplicationData* a;
  
  printf("$Id: rnasmonitor-singlepoint.c,v 1.7 2002/11/17 14:25:24 dancer Exp $\n");
  INITIALIZE_RNASMONITOR(r);

  if (require_lisp_params(r->l, 7))
    {
      fprintf(stderr, "This plugin requires: \n"
	      "SO, title, TAGx, TAGy, minx, maxx, miny, maxy\n");
      return 1;
    }

  a=calloc(sizeof(ApplicationData),1);
  a->tagx = getnthlisp(r->l, 2);
  a->tagy = getnthlisp(r->l, 3);
  a->minx = atof(getnthlisp(r->l, 4));
  a->maxx = atof(getnthlisp(r->l, 5));
  a->miny = atof(getnthlisp(r->l, 6));
  a->maxy = atof(getnthlisp(r->l, 7));
  r->applicationdata = a;

  if( (a->minx > a->maxx) || (a->miny > a->maxy))
    {
      fprintf(stderr, "This plugin requires: \n"
	      "minimum values to be smaller than maximum values.\n");
      return 1;
    }
  
  
  return 0;
}

static gint
expose_event(GtkWidget *widget,GdkEventExpose *event, gpointer really_p)
{
  /* this should be the perwindow_data*p */
  perwindow_data * p = really_p;
  
  if (!p)
    DEBUGPRINT("p is NULL");
  
  if (!p->g_pixmap)
    DEBUGPRINT("p->g_pixmap is NULL");
  
  gdk_draw_pixmap(p->drawingarea->window,
                  p->drawingarea->style->fg_gc[GTK_WIDGET_STATE(p->drawingarea)],
                  p->g_pixmap,
                  0,0,
                  0,0,
                  DRAW_AREA_WIDTH,DRAW_AREA_HEIGHT);
  return TRUE;
}


static GtkWidget* 
create_window_new(const char * hostname, GtkWidget * hbox, rnasmonitors* r, rnas_applicationdata *m)
{
  perwindow_data * p = calloc (sizeof(perwindow_data),1);
  GtkWidget* w;
  m->machine_applicationdata = p;
  
  w = gtk_vbox_new(FALSE, FALSE);

  if (!(p->drawingarea=gtk_drawing_area_new()))
    return (NULL);
  gtk_drawing_area_size(GTK_DRAWING_AREA(p->drawingarea),
                        DRAW_AREA_WIDTH,DRAW_AREA_HEIGHT);
  gtk_box_pack_start(GTK_BOX(hbox), w, TRUE, TRUE, FALSE);

  if (!(w->window))
    DEBUGPRINT("w->window is NULL");
  if (!(p->g_pixmap=gdk_pixmap_new(w->window,PIX_WIDTH,PIX_HEIGHT,-1)))
    return NULL;

  gtk_widget_set_events(p->drawingarea,GDK_EXPOSURE_MASK
                        | GDK_BUTTON_PRESS_MASK
                        | GDK_POINTER_MOTION_MASK
                        | GDK_KEY_PRESS_MASK);
  p->g_gc=gdk_gc_new(w->window);
  p->my_icon = gdk_pixmap_create_from_xpm(w->window,
					  &p->my_icon_shape,
					  NULL,
					  PKGDATADIR "/redball.xpm");
  if (!p->my_icon)
    {
      printf("error loading pixmap\n");
      exit (1);
    }

  gtk_box_pack_start(GTK_BOX(w), p->drawingarea, TRUE, TRUE, FALSE);

  gtk_signal_connect(GTK_OBJECT(p->drawingarea),"expose_event",	/* add NULL handler. */
		     (GtkSignalFunc)expose_event, p);
  gtk_widget_show(p->drawingarea);
  gtk_widget_show(w);
  gtk_widget_show(p->drawingarea);

  return w;
}

/*
   A callback function to display the object.
   Used for drawing, and used in INITIALIZE_RNASMONITOR.
 */
static int
displayfunction(struct rnas_applicationdata* m, dm_machinelist* dm)
{
  perwindow_data * p = m->machine_applicationdata;
  ApplicationData * a = m->r->applicationdata;
  float x,y, height, width, plotx, ploty;

  x = dm_get_value_float(dm, a->tagx);
  y = dm_get_value_float(dm, a->tagy);

  width = a->maxx -  a->minx ;
  height = a->maxy -  a->miny;
  plotx = ((x - a->minx) / width) * ((float)(PIX_WIDTH - ICON_WIDTH));
  ploty = ((y - a->miny) / height) * ((float)(PIX_HEIGHT - ICON_HEIGHT));
  
  gdk_draw_rectangle(p->g_pixmap,p->g_gc,TRUE,0,0,PIX_WIDTH,PIX_HEIGHT);
  gdk_gc_set_clip_mask(p->g_gc,p->my_icon_shape);
  gdk_gc_set_clip_origin(p->g_gc,plotx,ploty);
  gdk_draw_pixmap(p->g_pixmap,
		  p->g_gc,
		  p->my_icon,
		  0, 0, plotx , ploty,
		  ICON_WIDTH,ICON_HEIGHT);
  gtk_widget_queue_draw(p->drawingarea);
  
  return 0;
}

