<!--
		Local stylesheet for DocBook TDG

 Copyright (c) 2002-2003 Yann Dirson.
 Some code modified from Norman Walsh's stylesheets.
 GPL, version 2.

-->

<!DOCTYPE style-sheet PUBLIC "-//James Clark//DTD DSSSL Style Sheet//EN" [
<!ENTITY parent.dsl PUBLIC "-//Norman Walsh//DOCUMENT DocBook HTML Stylesheet//EN" CDATA dsssl>
]>
<style-sheet>
  <style-specification id="html" use="parent">
    <style-specification-body> 

;; parameter tuning
(define %shade-verbatim% #t)
(define html-index #t)

;; create xrefs from sgmltag's to the relevant refpages
(element sgmltag
  (let ((class (if (attribute-string (normalize "class"))
		   (attribute-string (normalize "class"))
		   (normalize "element"))))
    (cond
     ((equal? class (normalize "attribute"))  ($mono-seq$))
     ((equal? class (normalize "element"))
      ($mono-seq$ (make element
		    gi: "A"
		    attributes: `(("HREF" ,(string-append (case-fold-down
							   (data (current-node)) )
							  ".html"  )))  )) )
     (else ($charseq$)) )))


(mode title-sosofo-mode
  (element (refentry refmeta refentrytitle)
    (let ((version (case-fold-down
		    (attribute-string (normalize "revision")
				      (parent (parent))))))
      (make sequence
	(process-children-trim)
	(if version
	    (make empty-element
	      gi: "IMG"
	      attributes: `(("SRC" ,(string-append "figures/rev_" version ".png"))
			    ("ALT" ,(string-append "[" version "]"))))
	    (empty-sosofo))))))
      

(define %callout-graphics-path% "figures/callouts/")
(define %callout-graphics-extension% ".png")

(define %admon-graphics% #t)
(define %admon-graphics-path% "figures/admon/")
(define %admon-graphics-extension% ".png") 

(define ($admon-graphic$ #!optional (nd (current-node)))
  ;; REFENTRY admon-graphic
  ;; PURP Admonition graphic file
  ;; DESC
  ;; Given an admonition node, returns the name of the graphic that should
  ;; be used for that admonition.
  ;; /DESC
  ;; AUTHOR N/A
  ;; /REFENTRY
  (cond ((equal? (gi nd) (normalize "tip"))
         (string-append %admon-graphics-path% "tip" %admon-graphics-extension%))
        ((equal? (gi nd) (normalize "note"))
         (string-append %admon-graphics-path% "note" %admon-graphics-extension%))
        ((equal? (gi nd) (normalize "important"))
         (string-append %admon-graphics-path% "important" %admon-graphics-extension%))
        ((equal? (gi nd) (normalize "caution"))
         (string-append %admon-graphics-path% "caution" %admon-graphics-extension%))
        ((equal? (gi nd) (normalize "warning"))
         (string-append %admon-graphics-path% "warning" %admon-graphics-extension%))
        (else (error (string-append (gi nd) " is not an admonition.")))))

;; workaround bug in docbook-dsssl 1.78
(define (parse-starttag-pi pi)
  (let* ((strippi (strip pi))
	 (spacepos (string-index strippi " ")))
    (if (< spacepos 0)
	(list strippi)
	(list (substring strippi 0 spacepos)))))
	  

    </style-specification-body>
  </style-specification>

  <external-specification id="parent" document="parent.dsl">
</style-sheet>
