import junit.framework.*;

/**
 * Unit test for the IGKey class
 *
 * @author Ben Secrest
 * @version $Id: IGKeyTest.java,v 1.2 2002/08/31 22:00:22 blsecres Exp $
 */
public class IGKeyTest extends TestCase {
    private IGKey key0;
    private IGKey key1;


    /**
     * Initialize IGKey objects for use in tests
     */
    protected void setUp() {
	key0 = new IGKey(0);
	key1 = new IGKey(1);
    }


    /**
     * Test IGKey.getValue()
     */
    public void testGetValue() {
	Assert.assertEquals(key0.getValue(), 0);
	Assert.assertEquals(key1.getValue(), 1);
    }


    /**
     * Test the multiple versions of IGKey.equals()
     */
    public void testEquals() {
	Assert.assertFalse(key0.equals(null));
	Assert.assertEquals(key0, key0);
	Assert.assertEquals(key0, new IGKey(0));
	Assert.assertTrue(key0.equals(key0));
	Assert.assertFalse(key0.equals(key1));
	Assert.assertTrue(key0.equals((Object) key0));
	Assert.assertFalse(key0.equals((Object) key1));
    }


    /**
     * Test the values assigned to the static IGKey objects
     */
    public void testStaticValues() {
	Assert.assertSame(IGKey.TITLE, IGKey.TITLE);
	Assert.assertNotSame(IGKey.TITLE, new IGKey(1));
	Assert.assertEquals(IGKey.TITLE, new IGKey(1));
	Assert.assertEquals(IGKey.AUTHOR.getValue(), 2);
    }
}
