import re
from dosage.modules.helpers.BasicComicModule import BasicComicModule

class DieselSweeties(BasicComicModule):
    latestUrl = 'http://www.dieselsweeties.com/'
    imageUrl = 'http://www.dieselsweeties.com/archive.php?s=%s'
    imageSearch = re.compile(r'<img src="(/hstrips/\d+/\d+/\d+/\d+/\d{5}\..+?)" border="0" alt="newest cartoon">')
    prevSearch = re.compile(r'<a.+?href="((?:http://www.dieselsweeties.com/)?archive\.php\?s=\d+)">')
    help = 'Index format: n (unpadded)'

    def getFilename(self, imageUrl, pageUrl):
        index = int(imageUrl.split('/')[-1].split('.')[0])
        return 'sw%02d' % (index,)
