import re
import os.path
from dosage.modules.helpers.BasicComicModule import BasicComicModule

class StarCrossdDestiny(BasicComicModule):
    latestUrl = 'http://starcrossd.net/'
    imageUrl = 'http://www.starcrossd.net/archives/%s.html'
    imageSearch = re.compile(r'<img src="((?:http://(?:www\.)?starcrossd\.net/(?:ch1/)?strips/\d+\.[^"]+)|(?:http://(?:www\.)?juno\.gewdguys\.com/\w+/\d+\.[^"]+))"[^>]*>')
    prevSearch = re.compile(r'<a href="(http://www\.starcrossd\.net/(?:ch1/)?archives/\d+\.html)"[^>]*"[^"]*"[^>]*><img src="http://starcrossd.net/parts/comic_prev.gif" border="0">', re.IGNORECASE)
    help = 'Index format: nnnnnnnn'

    def getFilename(self, imageUrl, pageUrl):
        if imageUrl.find('ch1') == -1:
            imageUrl = re.sub('(?:strips)|(?:images)','book1',imageUrl) # At first all images were stored in a strips/ directory but that was changed with the introduction of book2
        elif not imageUrl.find('strips') == -1:
            imageUrl = imageUrl.replace('strips/','')
        directory, filename = imageUrl.split('/')[-2:]
        filename, extension = os.path.splitext(filename)
        return directory + '-' + filename
