import re
from dosage.modules.helpers.BasicComicModule import BasicComicModule
from dosage.util import getQueryParams

class Wulffmorgenthaler(BasicComicModule):
    latestUrl = 'http://www.wulffmorgenthaler.com/'
    imageUrl = 'http://www.wulffmorgenthaler.com/Default.aspx?id=%s'
    imageSearch = re.compile(r'img id="ctl00_content_Strip1_imgStrip".+?class="strip" src="(striphandler\.ashx\?stripid=[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12})"')
    prevSearch = re.compile(r'<a href="(/Default\.aspx\?id=[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12})" id="ctl00_content_Strip1_aPrev">')
    help = 'Index format: xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx (GUID)'

    def getFilename(self, imageUrl, pageUrl):
        return getQueryParams(imageUrl)['stripid'][0]
