/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Copyright 2002-2004 Todd Kulesza
 *
 * Authors:
 * 		Todd Kulesza <todd@dropline.net>
 */

#ifndef _XMLRPC_H_
#define _XMLRPC_H_

#include <libxml/parser.h>
#include <glib.h>

enum
{
	XMLRPC_TYPE_INT,
	XMLRPC_TYPE_BOOL,
	XMLRPC_TYPE_STRING,
	XMLRPC_TYPE_DOUBLE,
	XMLRPC_TYPE_DATE,
	XMLRPC_TYPE_BASE64,
	XMLRPC_TYPE_NODE
};

/* Build an XML-RPC packet from a -1-terminated list of types and values */
gchar*
xmlrpc_build_packet (const gchar *name, ...);

/* Parse an XML-RPC packet into a hash table of name-value pairs */
GHashTable*
xmlrpc_parse_packet (const gchar *xml, gint lenth);

/* Build an XML node for an integer value */
xmlNodePtr
xmlrpc_build_value_int (gint value);

/* Build an XML node for a boolean value */
xmlNodePtr
xmlrpc_build_value_bool (gboolean value);

/* Build an XML node for a string value */
xmlNodePtr
xmlrpc_build_value_string (const gchar *value);

/* Build an XML node for a double value */
xmlNodePtr
xmlrpc_build_value_double (gdouble value);

/* Build an XML node for a date/time value */
xmlNodePtr
xmlrpc_build_value_date (GTimeVal value);

/* Build an XML node for a base64 value */
xmlNodePtr
xmlrpc_build_value_base64 (const gchar *value);

/* Build an XML node for a struct value-pair */
xmlNodePtr
xmlrpc_build_value_struct (void);

/* Add a membernode to a struct */
void
xmlrpc_struct_add (xmlNodePtr parent, const gchar *name, xmlNodePtr value);

/* Build an XML node for an array of values */
xmlNodePtr
xmlrpc_build_value_array (void);

/* Add a value to an XML array */
void
xmlrpc_array_add (xmlNodePtr array, xmlNodePtr value);

void
print_xml (xmlNodePtr node);

#endif /* _XMLRPC_H_ */
