(module run mzscheme
  (define input-map
    '(
      ("ackermann.ss" . "11")
      ("ary.ss" . "9000")
      ("binarytrees.ss" . "16")
      ("chameneos.ss")
      ("cheapconcurrency.ss")
      ("echo.ss" . "150000")
      ("except.ss" . "2500000")
      ("fannkuch.ss")
      ("fasta.ss")
      ("fibo.ss" . "32")
      ("hash.ss" . "100000")
      ("hash2.ss" . "200")
      ("heapsort.ss" . "100000")
      ("lists.ss" . "18")
      ("mandelbrot.ss")
      ("matrix.ss" . "600")
      ("moments.ss" . "200")
      ("nbody.ss")
      ("nestedloop.ss" . "18")
      ("nsieve.ss")
      ("nsievebits.ss")
      ("partialsums.ss")
      ("pidigits.ss")
      ("pidigits1.ss")
      ("random.ss" . "900000")
      ("recursive.ss")
      ("regexmatch.ss")
      ("regexpdna.ss")
      ("reversecomplement.ss")
      ("reversefile.ss")
      ("sieve.ss" . "1200")
      ("spellcheck.ss")
      ("strcat.ss" . "40000")
      ("sumcol.ss")
      ("wc.ss")
      ("wordfreq.ss")
      ))

  (let ([len (vector-length (current-command-line-arguments))])
    (unless (= 1 len)
      (error 'run "provide ~athe name of a benchmark on the command line"
             (if (zero? len) "" "ONLY "))))

  (let ([prog (vector-ref (current-command-line-arguments) 0)])
    (let ([m (assoc prog input-map)])
      (unless m
        (error 'run "cannot find input for ~a" prog))
      (when (null? (cdr m))
        (error 'run "don't know input for ~a" prog))
      (parameterize ([current-command-line-arguments (vector (cdr m))])
        (time (dynamic-require prog #f))))))
