-- Copyright (C) 1999 Daniel Elphick and others
-- Licensed under Eiffel Forum Freeware License, version 1;
-- (see forum.txt)
--
indexing

   description:  "Index to prevent duplication of class names"
   author:  "Oliver ELphick <olly@lfix.co.uk>"
   date:    "9 January 2001"
   cvs:     "$Id: class_index.e,v 1.2 2002/08/26 02:43:18 DJAC Exp $"

class CLASS_INDEX

inherit

	WRITER

feature

	classname: STRING

	filename: STRING

	class_index: DS_ARRAYED_LIST[STRING] is
		once
			create Result.make_equal(20)
		end

	generate_name(n: STRING; renameable: BOOLEAN) is
			-- generate a unique classname; if renameable is false, the 
			-- given name must be unique; if a name cannot be generated 
			-- the program is terminated witha fatal error
		require
			name_set: n /= Void and then n.count > 0
		local
			s: STRING
			i: INTEGER
			f: BOOLEAN
		do
			from
				s := clone(n)
			variant
				999-i
			until
				f or (i > 0 and not renameable)
			loop
				s := clone(n)
				s.to_upper
				if i > 0 then
					s.extend('_')
					s.append(i.out)
				end
				if not class_index.has(s) then
					class_index.force_last(s)
					f := True
					classname := s
					filename := clone(classname)
					filename.to_lower
					filename.prepend(src_dir)
					filename.append(".e")
				end
				i := i + 1
			end
			if not f then
				std_error.put_string("Duplicate class name %'")
				std_error.put_string(s)
				std_error.put_string("%' cannot be renamed%N")
				die_with_code(2)
			end
		ensure
			class_made: classname /= Void and then classname.count > 0
			file_made: filename /= Void and then filename.count > 0
		end

	generate_root_name(n, src: STRING) is
		require
			name_set: n /= Void and then n.count > 0
		do
			src_dir := clone(src)
			src_dir.extend('/')
			generate_name(n, False)
			root_name.make_from_string(classname)
			root_file.make_from_string(filename)
		ensure
			class_made: root_name /= Void and then root_name.count > 0
			file_made: root_file /= Void and then root_file.count > 0
		end

end -- CLASS_INDEX
