-- Copyright (C) 1999 Daniel Elphick and others
-- Licensed under Eiffel Forum Freeware License, version 1;
-- (see forum.txt)
--
indexing

	description:	"This class is the ancestor of preserved classes"
	author:		"Oliver Elphick <olly@lfix.co.uk>"
	date:          "October 31 1999"
	cvs:           "$Id: preserved_class_writer.e,v 1.2 2003/01/01 21:34:19 elphick Exp $"

deferred class PRESERVED_CLASS_WRITER

-- This class should be inherited by class writers that will not 
-- overwrite their targets if the targets already exist.

inherit

   CLASS_WRITER
      redefine
	 write_class, regeneration_status
      end

feature

	gen_inherit is
		do
			if not inherit_from.is_empty then
				!!inherit_list.make
				inherit_list.add(inherit_klass)
			end
		end

	write_class is
		do
			if not file_exists(filename) then
				precursor
			end
		end

	regeneration_status: STRING is
		do
			Result := "on_regeneration: %"This class text will be preserved%""
		end

end -- PRESERVED_CLASS_WRITER
