-- Copyright (C) 1999 Daniel Elphick and others
-- Licensed under Eiffel Forum Freeware License, version 1;
-- (see forum.txt)
--
indexing
	
	description: "Writes code for signals"
	author: "Daniel Elphick <dre00r@ecs.soton.ac.uk>"
	cvs: "$Id: signal_writer.e,v 1.12 2002/08/26 02:42:50 DJAC Exp $"

class SIGNAL_WRITER

inherit

	PRESERVED_CLASS_WRITER

	CAN_BE_CREATED

creation

	make

feature

--	inherit_from: STRING is "GTK_COMMAND"

	inherit_from: STRING is
		do
			-- if signal name ends with "event" then we inherit from GDK_EVENT_COMMAND
			if name.first_substring_index("_event") /= 0 then
				Result := "GDK_EVENT_COMMAND"
			else
				Result := "GTK_COMMAND"
			end
		end

	name: STRING

	handler: STRING
	handler_instance: STRING

	last_mod_time: STRING

	parent_inherit: INHERIT_LIST is
		do
			create Result.make
		end

	append_parent_creation(code: ARRAY[STRING]) is
		do
			code.add_last("create " + handler_instance + ".make(Current)")
		end

	append_parent_declaration(code: ARRAY[STRING]) is
		do
			code.add_last(handler_instance + ": "+classname)
		end

	append_top_level_show(code: ARRAY[STRING]) is
		do
		end

	append_top_level_definition(code: ARRAY[STRING]) is
		do
		end

	write_make_body is
		do
			write_line("make(par: GTK_OBJECT) is")
			indent
			write_line("do")
			indent
			write_line("window := par")
			outdent
			write_line("end")
			outdent
		end
		
	write_features is
		do
			write_line("window: GTK_OBJECT")
			blank_line
			write_line("execute is")
			indent
			write_line("do")
			indent
			write_line("-- window is set to be the window in which the widget")
			write_line("-- is located")
			write_line("debug")
			indent
			write_line("io.put_string(%"signal handler: " + handler + "%%N%")")
			outdent
			write_line("end")
			write_line("-- insert handler code here")
			outdent
			write_line("end")
			outdent
		end

feature {NONE}

	signals_list: DICTIONARY[INTEGER, STRING] is
		-- handler name maps to the number of times the handler has been used
		once
			create Result.make
		end

	make(tree: TAG_TREE; src: STRING) is
		require
			valid_tree: tree /= Void
			valid_src: src /= Void
		local
			signals_count: INTEGER
		do
			src_dir := src
			name := tree.get_string_from_field("name")
			handler := tree.get_string_from_field("handler")
			last_mod_time := tree.get_string_from_field("last_modification_time")
			name.to_lower
			create inherit_list.make
			inherit_list.add(inherit_klass)
			if signals_list.has(handler) then
				signals_count := signals_list.at(handler) + 1
				-- Do this here so that we don't have to remember a classname
				classname := clone(handler)
				classname.to_upper
				filename := clone(handler)
				filename.to_lower
				filename.append(".e")
				filename.prepend(src)
			else
				signals_count := 1
				-- Don't allow the name to be changed
				generate_name(handler, False)
			end
			signals_list.put(signals_count, handler)
			handler_instance := clone(handler)
			handler_instance.append(signals_count.to_string)
		ensure
			fields_correct: name /= Void and
								 handler /= Void and
								 last_mod_time /= Void
		end

end
