-- cOpyright (C) 1999 Daniel Elphick and others
-- Licensed under Eiffel Forum Freeware License, version 1;
-- (see forum.txt)
--
indexing

	description: "Writes source files for GtkAspectFrame objects"
	author: "Daniel Elphick <dre00r@ecs.soton.ac.uk>"
	cvs: "$Id: gtk_aspect_frame_writer.e,v 1.6 2002/08/26 02:31:19 DJAC Exp $"

class GTK_ASPECT_FRAME_WRITER

inherit

	GTK_FRAME_WRITER
		redefine
			type, make, creation_feature
		end

creation

	make

feature

	type: STRING is "GTK_ASPECT_FRAME"
	
	make(attr_name: STRING; tree: TAG_TREE; src: STRING) is
		do
			precursor(attr_name, tree, src)
			xalign := widget_tree.get_real_string_from_field("xalign")
			yalign := widget_tree.get_real_string_from_field("yalign")
			ratio := widget_tree.get_real_string_from_field("ratio")
			obey_child := widget_tree.get_boolean_string_from_field("obey_child")
		end
			
	xalign: STRING
	yalign: STRING
	ratio: STRING
	obey_child: STRING

	creation_feature: STRING is
		do
			if label /= Void then
				Result := "create " + name + ".make(%""+label+"%", " + xalign +
					", " + yalign + ", " + ratio + ", " + obey_child + ")"
			else
				Result := "create " + name + ".make_no_label(" + xalign +
					", " + yalign + ", " + ratio + ", " + obey_child + ")"
			end
		end

end
