-- Copyright (C) 1999 Daniel Elphick and others
-- Licensed under Eiffel Forum Freeware License, version 1;
-- (see forum.txt)
--
indexing

	description: "Writes source files for GtkButton objects"
	author: "Daniel Elphick <dre00r@ecs.soton.ac.uk>"
	cvs: "$Id: gtk_button_writer.e,v 1.13 2002/08/26 02:31:19 DJAC Exp $"

class GTK_BUTTON_WRITER

inherit

	GTK_BIN_WRITER
		rename
			make as make_attribute
		redefine
			append_parent_creation, append_parent_declaration
		end

	CHILD

creation

	make

feature

	type: STRING is "GTK_BUTTON"
	
	make(attr_name: STRING; tree: TAG_TREE; src: STRING) is
		require
			non_void_tree: tree /= Void
			valid_name: attr_name /= Void and then not attr_name.is_empty
		local
			temp_tree: TAG_TREE
		do
			make_attribute(attr_name, tree, src)
			label := widget_tree.get_string_from_field("label")
			if label.is_empty then
				icon := widget_tree.get_string_from_field("icon")
				if not icon.is_empty then
					-- NEED TO ADD CODE TO CHECK FOR NAME OVERLAPScreate !
					-- problems occur if the same icon is used twice as the same
					-- name is generated which means that it causes compiler
					-- problems.
					icon_feature := clone(icon)
					icon_feature.replace_all('.', '_')
				else
					temp_tree := widget_tree.find_child("widget")
					if temp_tree /= Void then
						create_child_class(temp_tree, 1)
					end
				end
			end
		end
			
	label: STRING
	icon: STRING
	icon_feature: STRING

	append_parent_declaration(code: ARRAY[STRING]) is
		do
			precursor(code)
			if label.is_empty and then not icon.is_empty then
				code.add_last(icon_feature + ": GTK_PIXMAP")
			end
		end
		
	append_parent_creation(code: ARRAY[STRING]) is
		do
			if label.is_empty and then not icon.is_empty then
				code.add_last("create " + name + ".make")
				-- This assumes Current will be the parent window!
				code.add_last("create " + icon_feature + ".make_from_xpm(Current , %"" + icon + "%")")
				code.add_last(name + ".add_widget("+icon_feature+")")
			elseif last_class /= Void then
				code.add_last("create " + name + ".make")
				precursor(code)
			else
				code.add_last("create " + name + ".make_with_label(%""+label+"%")")
			end
			add_widget_code(code)
		end
end
