-- Copyright (C) 1999 Daniel Elphick and others
-- Licensed under Eiffel Forum Freeware License, version 1;
-- (see forum.txt)
--
indexing

	description: "Writes source files for GtkTable objects"
	author: "Daniel Elphick <dre00r@ecs.soton.ac.uk>"
	cvs: "$Id: gtk_table_writer.e,v 1.14 2002/08/26 02:33:20 DJAC Exp $"

class GTK_TABLE_WRITER

inherit

	GTK_COMPOSED_BIN_WRITER
		rename
			make as make_attribute
		redefine
			append_parent_creation, append_add_widget_code
		end

	CHILD

creation

	make

feature

	type: STRING is "GTK_TABLE"
	
	make(attr_name: STRING; tree: TAG_TREE; src: STRING) is
		do
			make_attribute(attr_name, tree, src)
			rows := widget_tree.get_string_from_field("rows")
			columns := widget_tree.get_string_from_field("columns")
			homogeneous := widget_tree.get_boolean_string_from_field("homogeneous")
			if homogeneous = "" then
				homogeneous := "False"
			end
			row_spacing := widget_tree.get_string_from_field("row_spacing")
			column_spacing := widget_tree.get_string_from_field("column_spacing")
			create_child_class_array(widget_tree.find_children("widget"), 1)
		end
			
	row_spacing: STRING
	column_spacing: STRING
	homogeneous: STRING
	rows: STRING
	columns: STRING

	append_parent_creation(code: ARRAY[STRING]) is
		do
			code.add_last("create " + name + ".make("+rows+", "+columns+", "+homogeneous+")")
			code.add_last(name + ".set_row_spacings(" + row_spacing + ")")
			code.add_last(name + ".set_column_spacings(" + column_spacing + ")")
			add_widget_code(code)
			precursor(code)
		end

	append_add_widget_code(code: ARRAY[STRING]; widget: CAN_BE_CREATED) is
		local
			temp_child: CHILD
		do
			temp_child ?= widget
			code.add_last(name + ".attach("+ widget.name +
				", " + temp_child.property("left_attach") +
				", " + temp_child.property("right_attach") +
				", " + temp_child.property("top_attach") +
				", " + temp_child.property("bottom_attach") +
				", " + x_opt(temp_child) + ", " + y_opt(temp_child) +
				", " + temp_child.property("xpad") +
				", " + temp_child.property("ypad") + ")")
		end

	x_opt(child: CHILD): STRING is
		do
			create Result.make(10)
			if child.flag("xexpand", False) then
				Result.append("gtk_expand")
			end
			if child.flag("xshrink", False) then
				if not Result.is_empty then
					Result.append(" + ")
				end
				Result.append("gtk_shrink")
			end
			if child.flag("xfill", False) then
				if not Result.is_empty then
					Result.append(" + ")
				end
				Result.append("gtk_fill")
			end
			if Result.is_empty then
				Result.copy("0")
			end
		end

	y_opt(child: CHILD): STRING is
		do
			create Result.make(10)
			if child.flag("yexpand", False) then
				Result.append("gtk_expand")
			end
			if child.flag("yshrink", False) then
				if not Result.is_empty then
					Result.append(" + ")
				end
				Result.append("gtk_shrink")
			end
			if child.flag("yfill", False) then
				if not Result.is_empty then
					Result.append(" + ")
				end
				Result.append("gtk_fill")
			end
			if Result.is_empty then
				Result.copy("0")
			end
		end

end
