#ifndef __BOX_SELECTION_H__
#define __BOX_SELECTION_H__ 1
/* 
   elmo - ELectronic Mail Operator

   Copyright (C) 2003 rzyjontko

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; version 2.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  

*/
/*****************************************************************************
 *    INTERFACE REQUIRED HEADERS
 ****************************************************************************/
/*****************************************************************************
 *    INTERFACE DEFINITIONS / ENUMERATIONS / SIMPLE TYPEDEFS
 ****************************************************************************/
/****************************************************************************
 *    INTERFACE CLASS PROTOTYPES / EXTERNAL CLASS REFERENCES
 ****************************************************************************/
/****************************************************************************
 *    INTERFACE STRUCTURES / UTILITY CLASSES
 ****************************************************************************/
/****************************************************************************
 *    INTERFACE DATA DECLARATIONS
 ****************************************************************************/
/****************************************************************************
 *    INTERFACE FUNCTION PROTOTYPES
 ****************************************************************************/

extern void  box_selection_init (void);
extern void  box_selection_free_resources (void);

extern void  box_selection_refresh (void);
extern void  box_selection_redraw (void);
extern void  box_selection_set_focus (void);
extern void  box_selection_unset_focus (void);

/** move on to the next position */
extern void box_selection_next (void);
/** move to the previous position */
extern void box_selection_prev (void);
/** move on to the next page */
extern void box_selection_next_page (void);
/** move to the previous page */
extern void box_selection_prev_page (void);
/** move to the first position */
extern void box_selection_first (void);
/** move to the last position */
extern void box_selection_last (void);
/** re-read mailbox */
extern void box_selection_re_read (void);
/** open the selected box */
extern void box_selection_hit (void);
/** search forward */
extern void box_selection_search_backward (void);
/** search backward */
extern void box_selection_search_forward (void);

/****************************************************************************
 *    INTERFACE OBJECT CLASS DEFINITIONS
 ****************************************************************************/
/****************************************************************************
 *    INTERFACE TRAILING HEADERS
 ****************************************************************************/
/****************************************************************************
 *
 *    END HEADER box_selection.h
 *
 ****************************************************************************/
#endif
