#ifndef __POP_H__
#define __POP_H__ 1
/* 
   elmo - ELectronic Mail Operator

   Copyright (C) 2002, 2003, 2004 rzyjontko

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; version 2.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  

*/
/****************************************************************************
 *    INTERFACE REQUIRED HEADERS
 ****************************************************************************/

#include "mail.h"
#include "ask.h"

/****************************************************************************
 *    INTERFACE DEFINITIONS / ENUMERATIONS / SIMPLE TYPEDEFS
 ****************************************************************************/
/****************************************************************************
 *    INTERFACE CLASS PROTOTYPES / EXTERNAL CLASS REFERENCES
 ****************************************************************************/
/****************************************************************************
 *    INTERFACE STRUCTURES / UTILITY CLASSES
 ****************************************************************************/
/****************************************************************************
 *    INTERFACE DATA DECLARATIONS
 ****************************************************************************/
/****************************************************************************
 *    INTERFACE FUNCTION PROTOTYPES
 ****************************************************************************/

#ifdef __cplusplus
extern "C" {
#endif

extern void pop_init (void);
extern void pop_free_resources (void);

/*+
  Check all POP3 accounts if there is new mail waiting in your maildrop.
  This function checks accounts one after another until it encounters
  an account wit non-empty maildrop.  In such a case it displays which
  account was it (with number of messages), and runs a command given by
  variable sound_app.
  E.g.:
     set sound_app "/usr/bin/play /usr/share/sound/getmail.wav"
  +*/
/** check whether there is new mail */
extern void pop_check_new_mail (void);
/** fetch all messages from single account */
extern void pop_fetch (void);
/** remove all messages from single account */
extern void pop_purge (void);
/** fetch and remove all messages from single account */
extern void pop_fetch_purge (void);
/** fetch all messagess from all accounts */
extern void pop_fetch_all (void);
/** remove all messages from all accounts */
extern void pop_purge_all (void);
/** fetch and remove all messages from all accounts */
extern void pop_fetch_purge_all (void);

extern void pop_open_interactive (void);
extern void pop_fetch_interactive (int num);
extern void pop_delete_interactive (int num);
extern void pop_reset_interactive (void);
extern void pop_close_interactive (void);
extern void pop_fetch_all_interactive (void);
extern void pop_delete_all_interactive (void);

extern mail_t *pop_mail_info (int num);
extern int     pop_mail_count (void);

#ifdef __cplusplus
}
#endif

/****************************************************************************
 *    INTERFACE OBJECT CLASS DEFINITIONS
 ****************************************************************************/
/****************************************************************************
 *    INTERFACE TRAILING HEADERS
 ****************************************************************************/
/****************************************************************************
 *
 *    END HEADER pop.h
 *
 ****************************************************************************/
#endif
