#ifndef __WRAPBOX_H__
#define __WRAPBOX_H__ 1
/* 
   elmo - ELectronic Mail Operator

   Copyright (C) 2003, 2004 rzyjontko

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; version 2.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  

*/
/****************************************************************************
 *    INTERFACE REQUIRED HEADERS
 ****************************************************************************/

#include "mail.h"
#include "str.h"

/****************************************************************************
 *    INTERFACE DEFINITIONS / ENUMERATIONS / SIMPLE TYPEDEFS
 ****************************************************************************/
/****************************************************************************
 *    INTERFACE CLASS PROTOTYPES / EXTERNAL CLASS REFERENCES
 ****************************************************************************/
/****************************************************************************
 *    INTERFACE STRUCTURES / UTILITY CLASSES
 ****************************************************************************/
/****************************************************************************
 *    INTERFACE DATA DECLARATIONS
 ****************************************************************************/

extern mail_array_t *wrapbox_marray;

/****************************************************************************
 *    INTERFACE FUNCTION PROTOTYPES
 ****************************************************************************/

#ifdef __cplusplus
extern "C" {
#endif

extern void   wrapbox_init (void);
extern void   wrapbox_free_resources (void);
extern int    wrapbox_read_box (const char *name);
extern int    wrapbox_mail_header (mail_t *mail, char **place);
extern str_t *wrapbox_mail_body (mail_t *mail, mime_t *mime, int no_decrypt);
extern char  *wrapbox_fetch_single (mail_t *mail);
extern char  *wrapbox_fetch_where (int n);
extern int    wrapbox_deliver_to (const char *file, const char *box);
extern void   wrapbox_remove (mail_t *mail);
extern int    wrapbox_move_mail_to (mail_t *mail, const char *box);
extern int    wrapbox_mail_size (mail_t *mail);
extern int    wrapbox_box_mail_count (const char *box, int *unread);
extern void   wrapbox_refresh (void);
extern void   wrapbox_apply_flag (mail_t *mail);
extern void   wrapbox_apply_flags (void);
extern int    wrapbox_mail_count (void);
extern void   wrapbox_dump_box (void);
extern void   wrapbox_empty_trash (void);

extern mail_array_t *wrapbox_open_box (const char *box);

#ifdef __cplusplus
}
#endif

/****************************************************************************
 *    INTERFACE OBJECT CLASS DEFINITIONS
 ****************************************************************************/
/****************************************************************************
 *    INTERFACE TRAILING HEADERS
 ****************************************************************************/
/****************************************************************************
 *
 *    END HEADER wrapbox.h
 *
 ****************************************************************************/
#endif
