;;; iso-insert.el --- insert functions for ISO 8859/1  -*- coding: iso-8859-1;-*-

;; Copyright (C) 1987, 1994, 2001, 2002, 2003, 2004, 2005, 2006
;;   Free Software Foundation, Inc.

;; Author: Howard Gayle
;; Maintainer: FSF
;; Keywords: i18n

;; This file is part of GNU Emacs.

;; GNU Emacs is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; GNU Emacs is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with GNU Emacs; see the file COPYING.  If not, write to the
;; Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
;; Boston, MA 02110-1301, USA.

;;; Commentary:

;; Provides keys for inserting ISO Latin-1 characters.  They use the
;; prefix key C-x 8.  Type C-x 8 C-h for a list.

;;; Code:

(defun insert-no-break-space ()
   (interactive "*")
   (insert ?\)
)

(defun insert-inverted-exclamation-mark ()
   (interactive "*")
   (insert ?\)
)

(defun insert-cent-sign ()
   (interactive "*")
   (insert ?\)
)

(defun insert-pound-sign ()
   (interactive "*")
   (insert ?\)
)

(defun insert-general-currency-sign ()
   (interactive "*")
   (insert ?\)
)

(defun insert-yen-sign ()
   (interactive "*")
   (insert ?\)
)

(defun insert-broken-vertical-line ()
   (interactive "*")
   (insert ?\)
)

(defun insert-section-sign ()
   (interactive "*")
   (insert ?\)
)

(defun insert-diaeresis ()
   (interactive "*")
   (insert ?\)
)

(defun insert-copyright-sign ()
   (interactive "*")
   (insert ?\)
)

(defun insert-ordinal-indicator-feminine ()
   (interactive "*")
   (insert ?\)
)

(defun insert-angle-quotation-mark-left ()
   (interactive "*")
   (insert ?\)
)

(defun insert-not-sign ()
   (interactive "*")
   (insert ?\)
)

(defun insert-soft-hyphen ()
   (interactive "*")
   (insert ?\)
)

(defun insert-registered-sign ()
   (interactive "*")
   (insert ?\)
)

(defun insert-macron ()
   (interactive "*")
   (insert ?\)
)

(defun insert-degree-sign ()
   (interactive "*")
   (insert ?\)
)

(defun insert-plus-or-minus-sign ()
   (interactive "*")
   (insert ?\)
)

(defun insert-superscript-two ()
   (interactive "*")
   (insert ?\)
)

(defun insert-superscript-three ()
   (interactive "*")
   (insert ?\)
)

(defun insert-acute-accent ()
   (interactive "*")
   (insert ?\)
)

(defun insert-micro-sign ()
   (interactive "*")
   (insert ?\)
)

(defun insert-pilcrow ()
   (interactive "*")
   (insert ?\)
)

(defun insert-middle-dot ()
   (interactive "*")
   (insert ?\)
)

(defun insert-cedilla ()
   (interactive "*")
   (insert ?\)
)

(defun insert-superscript-one ()
   (interactive "*")
   (insert ?\)
)

(defun insert-ordinal-indicator-masculine ()
   (interactive "*")
   (insert ?\)
)

(defun insert-angle-quotation-mark-right ()
   (interactive "*")
   (insert ?\)
)

(defun insert-fraction-one-quarter ()
   (interactive "*")
   (insert ?\)
)

(defun insert-fraction-one-half ()
   (interactive "*")
   (insert ?\)
)

(defun insert-fraction-three-quarters ()
   (interactive "*")
   (insert ?\)
)

(defun insert-inverted-question-mark ()
   (interactive "*")
   (insert ?\)
)

(defun insert-A-grave ()
   (interactive "*")
   (insert ?\)
)

(defun insert-A-acute ()
   (interactive "*")
   (insert ?\)
)

(defun insert-A-circumflex ()
   (interactive "*")
   (insert ?\)
)

(defun insert-A-tilde ()
   (interactive "*")
   (insert ?\)
)

(defun insert-A-umlaut ()
   (interactive "*")
   (insert ?\)
)

(defun insert-A-ring ()
   (interactive "*")
   (insert ?\)
)

(defun insert-AE ()
   (interactive "*")
   (insert ?\)
)

(defun insert-C-cedilla ()
   (interactive "*")
   (insert ?\)
)

(defun insert-E-grave ()
   (interactive "*")
   (insert ?\)
)

(defun insert-E-acute ()
   (interactive "*")
   (insert ?\)
)

(defun insert-E-circumflex ()
   (interactive "*")
   (insert ?\)
)

(defun insert-E-umlaut ()
   (interactive "*")
   (insert ?\)
)

(defun insert-I-grave ()
   (interactive "*")
   (insert ?\)
)

(defun insert-I-acute ()
   (interactive "*")
   (insert ?\)
)

(defun insert-I-circumflex ()
   (interactive "*")
   (insert ?\)
)

(defun insert-I-umlaut ()
   (interactive "*")
   (insert ?\)
)

(defun insert-D-stroke ()
   (interactive "*")
   (insert ?\)
)

(defun insert-N-tilde ()
   (interactive "*")
   (insert ?\)
)

(defun insert-O-grave ()
   (interactive "*")
   (insert ?\)
)

(defun insert-O-acute ()
   (interactive "*")
   (insert ?\)
)

(defun insert-O-circumflex ()
   (interactive "*")
   (insert ?\)
)

(defun insert-O-tilde ()
   (interactive "*")
   (insert ?\)
)

(defun insert-O-umlaut ()
   (interactive "*")
   (insert ?\)
)

(defun insert-multiplication-sign ()
   (interactive "*")
   (insert ?\)
)

(defun insert-O-slash ()
   (interactive "*")
   (insert ?\)
)

(defun insert-U-grave ()
   (interactive "*")
   (insert ?\)
)

(defun insert-U-acute ()
   (interactive "*")
   (insert ?\)
)

(defun insert-U-circumflex ()
   (interactive "*")
   (insert ?\)
)

(defun insert-U-umlaut ()
   (interactive "*")
   (insert ?\)
)

(defun insert-Y-acute ()
   (interactive "*")
   (insert ?\)
)

(defun insert-THORN ()
   (interactive "*")
   (insert ?\)
)

(defun insert-ss ()
   (interactive "*")
   (insert ?\)
)

(defun insert-a-grave ()
   (interactive "*")
   (insert ?\)
)

(defun insert-a-acute ()
   (interactive "*")
   (insert ?\)
)

(defun insert-a-circumflex ()
   (interactive "*")
   (insert ?\)
)

(defun insert-a-tilde ()
   (interactive "*")
   (insert ?\)
)

(defun insert-a-umlaut ()
   (interactive "*")
   (insert ?\)
)

(defun insert-a-ring ()
   (interactive "*")
   (insert ?\)
)

(defun insert-ae ()
   (interactive "*")
   (insert ?\)
)

(defun insert-c-cedilla ()
   (interactive "*")
   (insert ?\)
)

(defun insert-e-grave ()
   (interactive "*")
   (insert ?\)
)

(defun insert-e-acute ()
   (interactive "*")
   (insert ?\)
)

(defun insert-e-circumflex ()
   (interactive "*")
   (insert ?\)
)

(defun insert-e-umlaut ()
   (interactive "*")
   (insert ?\)
)

(defun insert-i-grave ()
   (interactive "*")
   (insert ?\)
)

(defun insert-i-acute ()
   (interactive "*")
   (insert ?\)
)

(defun insert-i-circumflex ()
   (interactive "*")
   (insert ?\)
)

(defun insert-i-umlaut ()
   (interactive "*")
   (insert ?\)
)

(defun insert-d-stroke ()
   (interactive "*")
   (insert ?\)
)

(defun insert-n-tilde ()
   (interactive "*")
   (insert ?\)
)

(defun insert-o-grave ()
   (interactive "*")
   (insert ?\)
)

(defun insert-o-acute ()
   (interactive "*")
   (insert ?\)
)

(defun insert-o-circumflex ()
   (interactive "*")
   (insert ?\)
)

(defun insert-o-tilde ()
   (interactive "*")
   (insert ?\)
)

(defun insert-o-umlaut ()
   (interactive "*")
   (insert ?\)
)

(defun insert-division-sign ()
   (interactive "*")
   (insert ?\)
)

(defun insert-o-slash ()
   (interactive "*")
   (insert ?\)
)

(defun insert-u-grave ()
   (interactive "*")
   (insert ?\)
)

(defun insert-u-acute ()
   (interactive "*")
   (insert ?\)
)

(defun insert-u-circumflex ()
   (interactive "*")
   (insert ?\)
)

(defun insert-u-umlaut ()
   (interactive "*")
   (insert ?\)
)

(defun insert-y-acute ()
   (interactive "*")
   (insert ?\)
)

(defun insert-thorn ()
   (interactive "*")
   (insert ?\)
)

(defun insert-y-umlaut ()
   (interactive "*")
   (insert ?\)
)

(defvar 8859-1-map nil "Keymap for ISO 8859/1 character insertion.")
(if 8859-1-map nil
   (setq 8859-1-map (make-keymap))
   (define-key 8859-1-map " "    'insert-no-break-space)
   (define-key 8859-1-map "!"    'insert-inverted-exclamation-mark)
   (define-key 8859-1-map "\""   (make-sparse-keymap))
   (define-key 8859-1-map "\"\"" 'insert-diaeresis)
   (define-key 8859-1-map "\"A"  'insert-A-umlaut)
   (define-key 8859-1-map "\"E"  'insert-E-umlaut)
   (define-key 8859-1-map "\"I"  'insert-I-umlaut)
   (define-key 8859-1-map "\"O"  'insert-O-umlaut)
   (define-key 8859-1-map "\"U"  'insert-U-umlaut)
   (define-key 8859-1-map "\"a"  'insert-a-umlaut)
   (define-key 8859-1-map "\"e"  'insert-e-umlaut)
   (define-key 8859-1-map "\"i"  'insert-i-umlaut)
   (define-key 8859-1-map "\"o"  'insert-o-umlaut)
   (define-key 8859-1-map "\"u"  'insert-u-umlaut)
   (define-key 8859-1-map "\"y"  'insert-y-umlaut)
   (define-key 8859-1-map "'"    (make-sparse-keymap))
   (define-key 8859-1-map "''"   'insert-acute-accent)
   (define-key 8859-1-map "'A"   'insert-A-acute)
   (define-key 8859-1-map "'E"   'insert-E-acute)
   (define-key 8859-1-map "'I"   'insert-I-acute)
   (define-key 8859-1-map "'O"   'insert-O-acute)
   (define-key 8859-1-map "'U"   'insert-U-acute)
   (define-key 8859-1-map "'Y"   'insert-Y-acute)
   (define-key 8859-1-map "'a"   'insert-a-acute)
   (define-key 8859-1-map "'e"   'insert-e-acute)
   (define-key 8859-1-map "'i"   'insert-i-acute)
   (define-key 8859-1-map "'o"   'insert-o-acute)
   (define-key 8859-1-map "'u"   'insert-u-acute)
   (define-key 8859-1-map "'y"   'insert-y-acute)
   (define-key 8859-1-map "$"    'insert-general-currency-sign)
   (define-key 8859-1-map "+"    'insert-plus-or-minus-sign)
   (define-key 8859-1-map ","    (make-sparse-keymap))
   (define-key 8859-1-map ",,"   'insert-cedilla)
   (define-key 8859-1-map ",C"   'insert-C-cedilla)
   (define-key 8859-1-map ",c"   'insert-c-cedilla)
   (define-key 8859-1-map "-"    'insert-soft-hyphen)
   (define-key 8859-1-map "."    'insert-middle-dot)
   (define-key 8859-1-map "/"    (make-sparse-keymap))
   (define-key 8859-1-map "//"   'insert-division-sign)
   (define-key 8859-1-map "/O"   'insert-O-slash)
   (define-key 8859-1-map "/o"   'insert-o-slash)
   (define-key 8859-1-map "1"    (make-sparse-keymap))
   (define-key 8859-1-map "1/"   (make-sparse-keymap))
   (define-key 8859-1-map "1/2"  'insert-fraction-one-half)
   (define-key 8859-1-map "1/4"  'insert-fraction-one-quarter)
   (define-key 8859-1-map "3"    (make-sparse-keymap))
   (define-key 8859-1-map "3/"   (make-sparse-keymap))
   (define-key 8859-1-map "3/4"  'insert-fraction-three-quarters)
   (define-key 8859-1-map "<"    'insert-angle-quotation-mark-left)
   (define-key 8859-1-map "="    'insert-macron)
   (define-key 8859-1-map ">"    'insert-angle-quotation-mark-right)
   (define-key 8859-1-map "?"    'insert-inverted-question-mark)
   (define-key 8859-1-map "A"    'insert-A-ring)
   (define-key 8859-1-map "E"    'insert-AE)
   (define-key 8859-1-map "C"    'insert-copyright-sign)
   (define-key 8859-1-map "D"    'insert-D-stroke)
   (define-key 8859-1-map "L"    'insert-pound-sign)
   (define-key 8859-1-map "P"    'insert-pilcrow)
   (define-key 8859-1-map "R"    'insert-registered-sign)
   (define-key 8859-1-map "S"    'insert-section-sign)
   (define-key 8859-1-map "T"    'insert-THORN)
   (define-key 8859-1-map "Y"    'insert-yen-sign)
   (define-key 8859-1-map "^"    (make-sparse-keymap))
   (define-key 8859-1-map "^1"   'insert-superscript-one)
   (define-key 8859-1-map "^2"   'insert-superscript-two)
   (define-key 8859-1-map "^3"   'insert-superscript-three)
   (define-key 8859-1-map "^A"   'insert-A-circumflex)
   (define-key 8859-1-map "^E"   'insert-E-circumflex)
   (define-key 8859-1-map "^I"   'insert-I-circumflex)
   (define-key 8859-1-map "^O"   'insert-O-circumflex)
   (define-key 8859-1-map "^U"   'insert-U-circumflex)
   (define-key 8859-1-map "^a"   'insert-a-circumflex)
   (define-key 8859-1-map "^e"   'insert-e-circumflex)
   (define-key 8859-1-map "^i"   'insert-i-circumflex)
   (define-key 8859-1-map "^o"   'insert-o-circumflex)
   (define-key 8859-1-map "^u"   'insert-u-circumflex)
   (define-key 8859-1-map "_"    (make-sparse-keymap))
   (define-key 8859-1-map "_a"   'insert-ordinal-indicator-feminine)
   (define-key 8859-1-map "_o"   'insert-ordinal-indicator-masculine)
   (define-key 8859-1-map "`"    (make-sparse-keymap))
   (define-key 8859-1-map "`A"   'insert-A-grave)
   (define-key 8859-1-map "`E"   'insert-E-grave)
   (define-key 8859-1-map "`I"   'insert-I-grave)
   (define-key 8859-1-map "`O"   'insert-O-grave)
   (define-key 8859-1-map "`U"   'insert-U-grave)
   (define-key 8859-1-map "`a"   'insert-a-grave)
   (define-key 8859-1-map "`e"   'insert-e-grave)
   (define-key 8859-1-map "`i"   'insert-i-grave)
   (define-key 8859-1-map "`o"   'insert-o-grave)
   (define-key 8859-1-map "`u"   'insert-u-grave)
   (define-key 8859-1-map "a"    'insert-a-ring)
   (define-key 8859-1-map "e"    'insert-ae)
   (define-key 8859-1-map "c"    'insert-cent-sign)
   (define-key 8859-1-map "d"    'insert-d-stroke)
   (define-key 8859-1-map "o"    'insert-degree-sign)
   (define-key 8859-1-map "s"    'insert-ss)
   (define-key 8859-1-map "t"    'insert-thorn)
   (define-key 8859-1-map "u"    'insert-micro-sign)
   (define-key 8859-1-map "x"    'insert-multiplication-sign)
   (define-key 8859-1-map "|"    'insert-broken-vertical-line)
   (define-key 8859-1-map "~"    (make-sparse-keymap))
   (define-key 8859-1-map "~A"   'insert-A-tilde)
   (define-key 8859-1-map "~N"   'insert-N-tilde)
   (define-key 8859-1-map "~O"   'insert-O-tilde)
   (define-key 8859-1-map "~a"   'insert-a-tilde)
   (define-key 8859-1-map "~n"   'insert-n-tilde)
   (define-key 8859-1-map "~o"   'insert-o-tilde)
   (define-key 8859-1-map "~~"   'insert-not-sign)
   (if (not (lookup-key global-map "\C-x8"))
      (define-key global-map "\C-x8" 8859-1-map))
)
(defalias '8859-1-map 8859-1-map)

(provide 'iso-insert)

;;; arch-tag: eb5f97bd-a034-4851-92ff-ab1f1bf92814
;;; iso-insert.el ends here
