# Configure paths for Emcast
# A hacked up version of Owen Taylor's gtk.m4 (Copyright 1997)

# Owen Taylor     97-11-3

dnl AM_PATH_EMCAST([MINIMUM-VERSION, [ACTION-IF-FOUND [, ACTION-IF-NOT-FOUND [, MODULES]]]])
dnl Test for EMCAST, and define EMCAST_CFLAGS and EMCAST_LIBS
dnl
AC_DEFUN(AM_PATH_EMCAST,
[dnl 
dnl Get the cflags and libraries from the emcast-config script
dnl
AC_ARG_WITH(emcast-prefix,[  --with-emcast-prefix=PFX   Prefix where Emcast is installed (optional)],
            emcast_config_prefix="$withval", emcast_config_prefix="")
AC_ARG_WITH(emcast-exec-prefix,[  --with-emcast-exec-prefix=PFX Exec prefix where Emcast is installed (optional)],
            emcast_config_exec_prefix="$withval", emcast_config_exec_prefix="")
AC_ARG_ENABLE(emcasttest, [  --disable-emcasttest       Do not try to compile and run a test Emcast program],
		    , enable_emcasttest=yes)

  for module in . $4
  do
      case "$module" in
         btp) 
             emcast_config_args="$emcast_config_args btp"
	 ;;
         emcast) 
             emcast_config_args="$emcast_config_args emcast"
         ;;
      esac
  done

  if test x$emcast_config_exec_prefix != x ; then
     emcast_config_args="$emcast_config_args --exec-prefix=$emcast_config_exec_prefix"
     if test x${EMCAST_CONFIG+set} != xset ; then
        EMCAST_CONFIG=$emcast_config_exec_prefix/bin/emcast-config
     fi
  fi
  if test x$emcast_config_prefix != x ; then
     emcast_config_args="$emcast_config_args --prefix=$emcast_config_prefix"
     if test x${EMCAST_CONFIG+set} != xset ; then
        EMCAST_CONFIG=$emcast_config_prefix/bin/emcast-config
     fi
  fi

  AC_PATH_PROG(EMCAST_CONFIG, emcast-config, no)
  min_emcast_version=ifelse([$1], ,0.1.0,$1)
  AC_MSG_CHECKING(for EMCAST - version >= $min_emcast_version)
  no_emcast=""
  if test "$EMCAST_CONFIG" = "no" ; then
    no_emcast=yes
  else
    EMCAST_CFLAGS=`$EMCAST_CONFIG $emcast_config_args --cflags`
    EMCAST_LIBS=`$EMCAST_CONFIG $emcast_config_args --libs`
    emcast_config_major_version=`$EMCAST_CONFIG $emcast_config_args --version | \
           sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\1/'`
    emcast_config_minor_version=`$EMCAST_CONFIG $emcast_config_args --version | \
           sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\2/'`
    emcast_config_micro_version=`$EMCAST_CONFIG $emcast_config_args --version | \
           sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\3/'`
    if test "x$enable_emcasttest" = "xyes" ; then
      ac_save_CFLAGS="$CFLAGS"
      ac_save_LIBS="$LIBS"
      CFLAGS="$CFLAGS $EMCAST_CFLAGS"
      LIBS="$EMCAST_LIBS $LIBS"
dnl
dnl Now check if the installed Emcast is sufficiently new. (Also sanity
dnl checks the results of emcast-config to some extent
dnl
      rm -f conf.emcasttest
      AC_TRY_RUN([
#include <emcast/libemcast.h>
#include <stdio.h>
#include <stdlib.h>

int 
main ()
{
  int major, minor, micro;
  char *tmp_version;

  system ("touch conf.emcasttest");

  /* HP/UX 9 (%@#!) writes to sscanf strings */
  tmp_version = g_strdup("$min_emcast_version");
  if (sscanf(tmp_version, "%d.%d.%d", &major, &minor, &micro) != 3) {
     printf("%s, bad version string\n", "$min_emcast_version");
     exit(1);
   }

  if ((emcast_major_version != $emcast_config_major_version) ||
      (emcast_minor_version != $emcast_config_minor_version) ||
      (emcast_micro_version != $emcast_config_micro_version))
    {
      printf("\n*** 'emcast-config --version' returned %d.%d.%d, but Emcast (%d.%d.%d)\n", 
             $emcast_config_major_version, $emcast_config_minor_version, $emcast_config_micro_version,
             emcast_major_version, emcast_minor_version, emcast_micro_version);
      printf ("*** was found! If emcast-config was correct, then it is best\n");
      printf ("*** to remove the old version of Emcast. You may also be able to fix the error\n");
      printf("*** by modifying your LD_LIBRARY_PATH enviroment variable, or by editing\n");
      printf("*** /etc/ld.so.conf. Make sure you have run ldconfig if that is\n");
      printf("*** required on your system.\n");
      printf("*** If emcast-config was wrong, set the environment variable EMCAST_CONFIG\n");
      printf("*** to point to the correct copy of emcast-config, and remove the file config.cache\n");
      printf("*** before re-running configure\n");
    } 
#if defined (EMCAST_MAJOR_VERSION) && defined (EMCAST_MINOR_VERSION) && defined (EMCAST_MICRO_VERSION)
  else if ((emcast_major_version != EMCAST_MAJOR_VERSION) ||
	   (emcast_minor_version != EMCAST_MINOR_VERSION) ||
           (emcast_micro_version != EMCAST_MICRO_VERSION))
    {
      printf("*** Emcast header files (version %d.%d.%d) do not match\n",
	     EMCAST_MAJOR_VERSION, EMCAST_MINOR_VERSION, EMCAST_MICRO_VERSION);
      printf("*** library (version %d.%d.%d)\n",
	     emcast_major_version, emcast_minor_version, emcast_micro_version);
    }
#endif /* defined (EMCAST_MAJOR_VERSION) ... */
  else
    {
      if ((emcast_major_version > major) ||
        ((emcast_major_version == major) && (emcast_minor_version > minor)) ||
        ((emcast_major_version == major) && (emcast_minor_version == minor) && (emcast_micro_version >= micro)))
      {
        return 0;
       }
     else
      {
        printf("\n*** An old version of Emcast (%d.%d.%d) was found.\n",
               emcast_major_version, emcast_minor_version, emcast_micro_version);
        printf("*** You need a version of Emcast newer than %d.%d.%d. The latest version of\n",
	       major, minor, micro);
        printf("*** Emcast is always available from http://www.eecs.umich.edu/~dhelder/misc/emcast.\n");
        printf("***\n");
        printf("*** If you have already installed a sufficiently new version, this error\n");
        printf("*** probably means that the wrong copy of the emcast-config shell script is\n");
        printf("*** being found. The easiest way to fix this is to remove the old version\n");
        printf("*** of Emcast, but you can also set the EMCAST_CONFIG environment to point to the\n");
        printf("*** correct copy of emcast-config. (In this case, you will have to\n");
        printf("*** modify your LD_LIBRARY_PATH enviroment variable, or edit /etc/ld.so.conf\n");
        printf("*** so that the correct libraries are found at run-time))\n");
      }
    }
  return 1;
}
],, no_emcast=yes,[echo $ac_n "cross compiling; assumed OK... $ac_c"])
       CFLAGS="$ac_save_CFLAGS"
       LIBS="$ac_save_LIBS"
     fi
  fi
  if test "x$no_emcast" = x ; then
     AC_MSG_RESULT(yes)
     ifelse([$2], , :, [$2])     
  else
     AC_MSG_RESULT(no)
     if test "$EMCAST_CONFIG" = "no" ; then
       echo "*** The emcast-config script installed by Emcast could not be found"
       echo "*** If Emcast was installed in PREFIX, make sure PREFIX/bin is in"
       echo "*** your path, or set the EMCAST_CONFIG environment variable to the"
       echo "*** full path to emcast-config."
     else
       if test -f conf.emcasttest ; then
        :
       else
          echo "*** Could not run Emcast test program, checking why..."
          CFLAGS="$CFLAGS $EMCAST_CFLAGS"
          LIBS="$LIBS $EMCAST_LIBS"
          AC_TRY_LINK([
#include <emcast/libemcast.h>
#include <stdio.h>
],      [ return ((emcast_major_version) || (emcast_minor_version) || (emcast_micro_version)); ],
        [ echo "*** The test program compiled, but did not run. This usually means"
          echo "*** that the run-time linker is not finding Emcast or finding the wrong"
          echo "*** version of Emcast. If it is not finding Emcast, you'll need to set your"
          echo "*** LD_LIBRARY_PATH environment variable, or edit /etc/ld.so.conf to point"
          echo "*** to the installed location  Also, make sure you have run ldconfig if that"
          echo "*** is required on your system"
	  echo "***"
          echo "*** If you have an old version installed, it is best to remove it, although"
          echo "*** you may also be able to get things to work by modifying LD_LIBRARY_PATH"
          echo "***"
          echo "*** If you have a RedHat 5.0 system, you should remove the Emcast package that"
          echo "*** came with the system with the command"
          echo "***"
          echo "***    rpm --erase --nodeps emcast emcast-devel" ],
        [ echo "*** The test program failed to compile or link. See the file config.log for the"
          echo "*** exact error that occured. This usually means Emcast was incorrectly installed"
          echo "*** or that you have moved Emcast since it was installed. In the latter case, you"
          echo "*** may want to edit the emcast-config script: $EMCAST_CONFIG" ])
          CFLAGS="$ac_save_CFLAGS"
          LIBS="$ac_save_LIBS"
       fi
     fi
     EMCAST_CFLAGS=""
     EMCAST_LIBS=""
     ifelse([$3], , :, [$3])
  fi
  AC_SUBST(EMCAST_CFLAGS)
  AC_SUBST(EMCAST_LIBS)
  rm -f conf.emcasttest
])
