/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *  Author: Stéphane Démurget  <stephane.demurget@enst-bretagne.fr>
 */

#ifndef __EF_MSG_QUEUE_H__
#define __EF_MSG_QUEUE_H__

#include "config.h"
#include <glib.h>

#define IPC_PATHNAME     DAEMONPATH
#define IPC_PROJECT_ID   2801 /* a birthday date ;) */
#define IPC_FALLBACK_KEY 0x31011981

/* Note: we can't use the EFBackendGovernors type because it's not the correct storage class,
	 but that's the type required to be used for the 'type' field */
typedef struct {
	long int type; 
	int frequency;
} EFMessage;

typedef struct {
	gboolean server_side;
	int id;
} EFMessageQueue;

EFMessageQueue *ef_msg_queue_new      (gboolean server_side);

gboolean	ef_msg_queue_is_alive (EFMessageQueue *queue);
gboolean	ef_msg_queue_send     (EFMessageQueue *queue, EFMessage *msg);
EFMessage      *ef_msg_queue_receive  (EFMessageQueue *queue);

void		ef_msg_queue_free     (EFMessageQueue *queue);

#endif
