/*
  emilda-print
  Part of the Emilda project (http://www.emilda.org/)
	
  Copyright (C) 2003 Realnode Ltd

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

  
  Authors:
    Mattias Nordstrom <nordstrom (at) realnode.com>

  $Id: epd.h,v 1.2 2003/12/27 19:18:43 matta Exp $
    This file provides the EPD (Emilda Print Data) class.

*/

#ifndef HAVE_EPD_H
#define HAVE_EPD_H

#include <string>
#include <fstream>

#define EPD_PARSE_OK      0	// OK.
#define EPD_PARSE_NODOC   1	// Not a valid EPD document.
#define EPD_PARSE_VER     2 // Incompatible EPD version.
#define EPD_PARSE_TYPE    3	// Incompatible type.

#define EPD_VERSION_MA    1	// Valid EPD version.
#define EPD_VERSION_MI    0

#define EPD_TYPE_PS       1
#define EPD_TYPE_LABEL    2
#define EPD_TYPE_RECEIPT  3

// TODO: Add constants list of barcode types.

using namespace std;

struct epd_doc {
	int version_ma,
		version_mi,
		type;
		struct {
			
		} options;
		string data;
};

class epd {
	public:
		epd();
		~epd();
		
		int parse_epd(void *fd);	
	
	//private:
		struct epd_doc document;
};

#endif
