/*
                                Object Opening
 */

#ifndef EDV_OPEN_H
#define EDV_OPEN_H

#include <glib.h>
#include "edv_context.h"


/*
 *	Opens the object(s) specified by the list of strings paths_list.
 *
 *	If command_name is not NULL then the command on the associated
 *	MIME Type who's name matches command_name will be used.
 *
 *	Typical values for command_name are; "default", "view",
 *	and "edit". However it is difficult to know what the user has
 *	set so it is recommended that you pass command_name as NULL
 *	when unsure.
 *
 *	Returns:
 *
 *	0	Success.
 *	-1	General error.
 *	-2	Invalid value or no such object.
 *	-3	System error or memory allocation error.
 *	-4	User aborted.
 *	-7	No associated MIME Type was found.
 */
extern gint EDVOpen(
	edv_context_struct *ctx,
	GList *paths_list, const gchar *command_name
);


#endif	/* EDV_OPEN_H */
