/*
                                    Pie Chart
 */

#ifndef PIE_CHART_H
#define PIE_CHART_H

#include <gtk/gtk.h>


typedef struct _pie_chart_struct	pie_chart_struct;
#define PIE_CHART(p)		((pie_chart_struct *)(p))
typedef struct _pie_chart_value_struct	pie_chart_value_struct;
#define PIE_CHART_VALUE(p)	((pie_chart_value_struct *)(p))


/*
 *	Pie Chart Value:
 */
struct _pie_chart_value_struct {

	GtkAdjustment *adj;	/* Only lower and upper used */
	GdkColor c, c_shade;

	GtkWidget *type_label_hbox, *value_label_hbox;
	GtkWidget *drawing_area;
	gchar *type_label, *value_label;

};

/*
 *	Pie Chart:
 */
struct _pie_chart_struct {

	gboolean	initialized,
			map_state;

	GtkWidget	*toplevel,
			*drawing_area,
			*type_labels_vbox,
			*value_labels_vbox,
			*title_label,
			*footer_label;

	GdkPixmap	*pixmap;	/* Off screen buffer for drawing area */
	gint		width, height;
	GdkGC		*gc;
	GdkColormap	*colormap;

	gboolean	realized;	/* If FALSE, indicates colors and
					 * other resources have not been
					 * created yet
					 */

	GtkAdjustment	*adj;	/* Only lower and upper used */
	GdkColor	c,
			c_shade,
			c_shadow;
	gchar		*base_type_label,
			*base_value_label;

	pie_chart_value_struct	**value;
	gint			total_values;

	gboolean	show_labels,
			shadows,
			outline;

};


extern gint PieChartValueAdd(
	pie_chart_struct *pc,
	GtkAdjustment *adj, GdkColor *c,
	const gchar *type_label, const gchar *value_label
);
extern void PieChartValueSet(
	pie_chart_struct *pc, gint value_num,
	GtkAdjustment *adj, GdkColor *c,
	const gchar *type_label, const gchar *value_label
);
extern void PieChartValueRemove(
	pie_chart_struct *pc, gint value_num
);
extern void PieChartValueRemoveAll(pie_chart_struct *pc);

extern pie_chart_struct *PieChartNew(
	GtkAdjustment *adj, GdkColor *c, gint width, gint height,
	const gchar *title, const gchar *footer,
	const gchar *base_type_label, const gchar *base_value_label
);
extern void PieChartMap(pie_chart_struct *pc);
extern void PieChartUnmap(pie_chart_struct *pc);
extern void PieChartDelete(pie_chart_struct *pc);


#endif	/* PIE_CHART_H */
