#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <gtk/gtk.h>
#include <gdk/gdkkeysyms.h>

#include "guiutils.h"
#include "ascii_chart_dlg.h"
#include "config.h"

#include "images/icon_copy_20x20.xpm"
#include "images/icon_ok_20x20.xpm"


static gint ASCIIChartDlgDeleteEventCB(
	GtkWidget *widget, GdkEvent *event, gpointer data
);
static gint ASCIIChartDlgCListEventCB(
	GtkWidget *widget, GdkEvent *event, gpointer data
);
static void ASCIIChartDlgCListSelectRowCB(
	GtkCList *clist, gint row, gint column, GdkEvent *event,
	gpointer data
);
static void ASCIIChartDlgCListUnselectRowCB(
	GtkCList *clist, gint row, gint column, GdkEvent *event,
	gpointer data
);
static void ASCIIChartDlgCopyToClipboardCB(GtkWidget *widget, gpointer data);
static void ASCIIChartDlgOKCB(GtkWidget *widget, gpointer data);

static void ASCIIChartDlgCopyToClipboard(ascii_chart_dlg_struct *d);

ascii_chart_dlg_struct *ASCIIChartDlgNew(GtkWidget *ref_toplevel);
void ASCIIChartDlgUpdateMenus(ascii_chart_dlg_struct *d);
gboolean ASCIIChartDlgIsMapped(ascii_chart_dlg_struct *d);
void ASCIIChartDlgMap(ascii_chart_dlg_struct *d);
void ASCIIChartDlgUnmap(ascii_chart_dlg_struct *d);
void ASCIIChartDlgDelete(ascii_chart_dlg_struct *d);


#define ASCII_CHART_DLG_DEF_WIDTH	400
#define ASCII_CHART_DLG_DEF_HEIGHT	350

/* Descriptions List */
#define ASCII_CHART_DLG_DESC_LIST	{			\
	"(NUL) Null",				/* 0x00	0 */	\
	"(SOH) Start of heading",				\
	"(STX) Start of text",					\
	"(ETX) End of text",					\
	"(EOT) End of transmission",				\
	"(ENQ) Enquery",					\
	"(ACK) Acknowledge",					\
	"(BEL) Bell",						\
	"(BS) Backspace",					\
	"(TAB) Horizontal tab",					\
	"(LF) Line feed or new line",		/* 0x0A 10 */	\
	"(VT) Vertical tab",					\
	"(FF) Form feed or new page",				\
	"(CR) Carrage return",					\
	"(SO) Shift out",					\
	"(SO) Shift in",					\
	"(DLE) Data link escape",				\
	"(DC1) Device control 1",				\
	"(DC2) Device control 2",				\
	"(DC3) Device control 3",				\
	"(DC4) Device control 4",		/* 0x14 20 */	\
	"(NAK) Do not acknowledge",				\
	"(SYN) Synchronous idle",				\
	"(ETB) End of transmission block",			\
	"(CAN) Cancel",						\
	"(EM) End of medium",					\
	"(SUB) Substitute",					\
	"(ESC) Escape",						\
	"(FS) File separator",					\
	"(GS) Group separator",					\
	"(RS) Record separator",		/* 0x1E 30 */	\
	"(US) Unit separator",					\
	"(SP) Space",						\
	NULL,							\
	NULL,							\
	NULL,							\
	NULL,							\
	NULL,							\
	NULL,							\
	NULL,							\
	NULL,					/* 40 */	\
	NULL,							\
	NULL,							\
	NULL,							\
	NULL,							\
	NULL,							\
	NULL,							\
	NULL,							\
	NULL,							\
	NULL,							\
	NULL,					/* 50 */	\
	NULL,							\
	NULL,							\
	NULL,							\
	NULL,							\
	NULL,							\
	NULL,							\
	NULL,							\
	NULL,							\
	NULL,							\
	NULL,					/* 60 */	\
	NULL,							\
	NULL,							\
	NULL,							\
	NULL,							\
	NULL,							\
	NULL,							\
	NULL,							\
	NULL,							\
	NULL,							\
	NULL,					/* 70 */	\
	NULL,							\
	NULL,							\
	NULL,							\
	NULL,							\
	NULL,							\
	NULL,							\
	NULL,							\
	NULL,							\
	NULL,							\
	NULL,					/* 80 */	\
	NULL,							\
	NULL,							\
	NULL,							\
	NULL,							\
	NULL,							\
	NULL,							\
	NULL,							\
	NULL,							\
	NULL,							\
	NULL,					/* 90 */	\
	NULL,							\
	NULL,							\
	NULL,							\
	NULL,							\
	NULL,							\
	NULL,							\
	NULL,							\
	NULL,							\
	NULL,							\
	NULL,					/* 100 */	\
	NULL,							\
	NULL,							\
	NULL,							\
	NULL,							\
	NULL,							\
	NULL,							\
	NULL,							\
	NULL,							\
	NULL,							\
	NULL,					/* 110 */	\
	NULL,							\
	NULL,							\
	NULL,							\
	NULL,							\
	NULL,							\
	NULL,							\
	NULL,							\
	NULL,							\
	NULL,							\
	NULL,					/* 120 */	\
	NULL,							\
	NULL,							\
	NULL,							\
	NULL,							\
	NULL,							\
	NULL,							\
	"(DEL)",						\
	NULL,							\
	NULL,							\
	NULL,					/* 130 */	\
	NULL,							\
	NULL,							\
	NULL,							\
	NULL,							\
	NULL,							\
	NULL,							\
	NULL,							\
	NULL,							\
	NULL,							\
	NULL,					/* 140 */	\
	NULL,							\
	NULL,							\
	NULL,							\
	NULL,							\
	NULL,							\
	NULL,							\
	NULL,							\
	NULL,							\
	NULL,							\
	NULL,					/* 150 */	\
	NULL,							\
	NULL,							\
	NULL,							\
	NULL,							\
	NULL,							\
	NULL,							\
	NULL,							\
	NULL,							\
	NULL,							\
	NULL,					/* 160 */	\
	NULL,							\
	NULL,							\
	NULL,							\
	NULL,							\
	NULL,							\
	NULL,							\
	NULL,							\
	NULL,							\
	NULL,							\
	NULL,					/* 170 */	\
	NULL,							\
	NULL,							\
	NULL,							\
	NULL,							\
	NULL,							\
	NULL,							\
	NULL,							\
	NULL,							\
	NULL,							\
	NULL,					/* 180 */	\
	NULL,							\
	NULL,							\
	NULL,							\
	NULL,							\
	NULL,							\
	NULL,							\
	NULL,							\
	NULL,							\
	NULL,							\
	NULL,					/* 190 */	\
	NULL,							\
	NULL,							\
	NULL,							\
	NULL,							\
	NULL,							\
	NULL,							\
	NULL,							\
	NULL,							\
	NULL,							\
	NULL,					/* 200 */	\
	NULL,							\
	NULL,							\
	NULL,							\
	NULL,							\
	NULL,							\
	NULL,							\
	NULL,							\
	NULL,							\
	NULL,							\
	NULL,					/* 210 */	\
	NULL,							\
	NULL,							\
	NULL,							\
	NULL,							\
	NULL,							\
	NULL,							\
	NULL,							\
	NULL,							\
	NULL,							\
	NULL,					/* 220 */	\
	NULL,							\
	NULL,							\
	NULL,							\
	NULL,							\
	NULL,							\
	NULL,							\
	NULL,							\
	NULL,							\
	NULL,							\
	NULL,					/* 230 */	\
	NULL,							\
	NULL,							\
	NULL,							\
	NULL,							\
	NULL,							\
	NULL,							\
	NULL,							\
	NULL,							\
	NULL,							\
	NULL,					/* 240 */	\
	NULL,							\
	NULL,							\
	NULL,							\
	NULL,							\
	NULL,							\
	NULL,							\
	NULL,							\
	NULL,							\
	NULL,							\
	NULL,					/* 250 */	\
	NULL,							\
	NULL,							\
	NULL,							\
	NULL,							\
	NULL					/* 0xFF 255 */	\
}


#define ATOI(s)         (((s) != NULL) ? atoi(s) : 0)
#define ATOL(s)         (((s) != NULL) ? atol(s) : 0)
#define ATOF(s)         (((s) != NULL) ? atof(s) : 0.0f)
#define STRDUP(s)       (((s) != NULL) ? g_strdup(s) : NULL)

#define MAX(a,b)        (((a) > (b)) ? (a) : (b))
#define MIN(a,b)        (((a) < (b)) ? (a) : (b))
#define CLIP(a,l,h)     (MIN(MAX((a),(l)),(h)))
#define STRLEN(s)       (((s) != NULL) ? strlen(s) : 0)
#define STRISEMPTY(s)   (((s) != NULL) ? (*(s) == '\0') : TRUE)


/*
 *	Toplevel GtkWindow "delete_event" signal callback.
 */
static gint ASCIIChartDlgDeleteEventCB(
	GtkWidget *widget, GdkEvent *event, gpointer data
)
{
	ASCIIChartDlgOKCB(widget, data);
	return(TRUE);
}

/*
 *	GtkCList any event signal callback.
 */
static gint ASCIIChartDlgCListEventCB(
	GtkWidget *widget, GdkEvent *event, gpointer data
)
{
	gint status = FALSE;
	GdkEventButton *button;
	ascii_chart_dlg_struct *d = ASCII_CHART_DLG(data);
	if((widget == NULL) || (event == NULL) || (d == NULL))
	    return(status);

	if(d->freeze_count > 0)
	    return(status);

	switch((gint)event->type)
	{
	  case GDK_BUTTON_PRESS:
	    button = (GdkEventButton *)event;
	    switch(button->button)
	    {
	      case GDK_BUTTON3:
		gtk_menu_popup(
		    GTK_MENU(d->menu), NULL, NULL,
		    NULL, NULL,
		    button->button, button->time
		);
		status = TRUE;
		break;
	    }
	    break;

	  case GDK_BUTTON_RELEASE:
	    button = (GdkEventButton *)event;
	    break;

	  case GDK_2BUTTON_PRESS:
	    ASCIIChartDlgCopyToClipboard(d);
	    break;
	}

	return(status);
}

/*
 *	GtkCList "select_row" signal callback.
 */
static void ASCIIChartDlgCListSelectRowCB(
	GtkCList *clist, gint row, gint column, GdkEvent *event,
	gpointer data
)
{
	ascii_chart_dlg_struct *d = ASCII_CHART_DLG(data);
	if((clist == NULL) || (d == NULL))
	    return;

	/* Scroll to the selected row if it is not visible */
	if(gtk_clist_row_is_visible(clist, row) !=
	   GTK_VISIBILITY_FULL
	)
	    gtk_clist_moveto(
		clist,
		row, -1,		/* Row, column */
		0.5f, 0.0f		/* Row, column */
	    );

	/* Clear the DND icon */
	GUIDNDSetDragIcon(NULL, NULL, 0, 0);

	ASCIIChartDlgUpdateMenus(d);
}

/*
 *	GtkCList "unselect_row" signal callback.
 */
static void ASCIIChartDlgCListUnselectRowCB(
	GtkCList *clist, gint row, gint column, GdkEvent *event,
	gpointer data
)
{
	ascii_chart_dlg_struct *d = ASCII_CHART_DLG(data);
	if((clist == NULL) || (d == NULL))
	    return;

	ASCIIChartDlgUpdateMenus(d);
}

/*
 *	Copy to clipboard callback.
 */
static void ASCIIChartDlgCopyToClipboardCB(GtkWidget *widget, gpointer data)
{
	ascii_chart_dlg_struct *d = ASCII_CHART_DLG(data);
	if(d == NULL)
	    return;

	if(d->freeze_count > 0)
	    return;

	ASCIIChartDlgCopyToClipboard(d);
}

/*
 *	OK Button callback.
 */
static void ASCIIChartDlgOKCB(GtkWidget *widget, gpointer data)
{
	ascii_chart_dlg_struct *d = ASCII_CHART_DLG(data);
	if(d == NULL)
	    return;

	ASCIIChartDlgUnmap(d);
}


/*
 *	Coppies the selected row's character value to the clipboard.
 */
static void ASCIIChartDlgCopyToClipboard(ascii_chart_dlg_struct *d)
{
	gchar *s;
	guint32 v;
	GtkCList *clist = GTK_CLIST(d->clist);
	GList *glist = clist->selection_end;
	const gint row = (glist != NULL) ? (gint)glist->data : -1;
	if(row < 0)
	    return;

	v = (guint32)gtk_clist_get_row_data(clist, row);
	s = g_strdup_printf("%c", (gchar)v);
	GUIDDESetString(
	    d->copy_btn,
	    GDK_SELECTION_PRIMARY,
	    GDK_CURRENT_TIME,
	    s
	);
	g_free(s);

	ASCIIChartDlgUpdateMenus(d);
}


/*
 *	Creates a new ASCII Chart Dialog.
 */
ascii_chart_dlg_struct *ASCIIChartDlgNew(GtkWidget *ref_toplevel)
{
	const gint	border_major = 5;
	gchar *titles[5];
	GdkWindow *window;
	GtkAccelGroup *accelgrp;
	GtkWidget	*w,
			*parent, *parent2,
			*toplevel;
	GtkCList *clist;
	ascii_chart_dlg_struct *d = ASCII_CHART_DLG(g_malloc0(
	    sizeof(ascii_chart_dlg_struct)
	));
	if(d == NULL)
	    return(NULL);

	d->toplevel = toplevel = gtk_window_new(GTK_WINDOW_DIALOG);
	d->accelgrp = accelgrp = gtk_accel_group_new();
	d->processing = FALSE;
	d->freeze_count = 0;

	d->freeze_count++;

	/* Toplevel GtkWindow */
	w = toplevel;
	gtk_window_set_title(
	    GTK_WINDOW(w),
	    PROG_NAME_FULL ": Extended ASCII Chart"
	);
	gtk_window_set_wmclass(
	    GTK_WINDOW(w), "dialog", PROG_NAME
	);
	gtk_widget_set_usize(
	    w,
	    ASCII_CHART_DLG_DEF_WIDTH, ASCII_CHART_DLG_DEF_HEIGHT
	);
	gtk_widget_realize(w);
	window = w->window;
	if(window != NULL)
	{
	    gdk_window_set_decorations(
		window,
		GDK_DECOR_BORDER | GDK_DECOR_TITLE | GDK_DECOR_MENU |
		GDK_DECOR_MINIMIZE
	    );
	    gdk_window_set_functions(
		window,
		GDK_FUNC_MOVE | GDK_FUNC_MINIMIZE | GDK_FUNC_CLOSE
	    );
/*	    GUISetWMIcon(window, (guint8 **)archiver_48x48_xpm); */
	}
	gtk_signal_connect(
	    GTK_OBJECT(w), "delete_event",
	    GTK_SIGNAL_FUNC(ASCIIChartDlgDeleteEventCB), d
	);
	gtk_container_border_width(GTK_CONTAINER(w), 0);
	gtk_window_add_accel_group(GTK_WINDOW(w), accelgrp);
	if((ref_toplevel != NULL) ?
	    GTK_IS_WINDOW(GTK_OBJECT(ref_toplevel)) : FALSE
	)
	{
	    gtk_window_set_transient_for(
		GTK_WINDOW(w), GTK_WINDOW(ref_toplevel)
	    );
	}
	parent = w;

	/* Main GtkVBox */
	d->main_vbox = w = gtk_vbox_new(FALSE, 0);
	gtk_container_border_width(GTK_CONTAINER(w), 0);
	gtk_container_add(GTK_CONTAINER(parent), w);
	gtk_widget_show(w);
	parent = w;

	/* GtkScrolledWindow for the GtkCList */
	w = gtk_scrolled_window_new(NULL, NULL);
	gtk_scrolled_window_set_policy(
	    GTK_SCROLLED_WINDOW(w),
	    GTK_POLICY_AUTOMATIC,
	    GTK_POLICY_AUTOMATIC
	);
	gtk_box_pack_start(GTK_BOX(parent), w, TRUE, TRUE, 0);
	gtk_widget_show(w);
	parent2 = w;

	/* GtkCList */
	titles[0] = "Hex";
	titles[1] = "Decimal";
	titles[2] = "Octal";
	titles[3] = "ASCII";
	titles[4] = "Description";
	d->clist = w = gtk_clist_new_with_titles(
	    sizeof(titles) / sizeof(gchar *),
	    titles
	);
	clist = GTK_CLIST(w);
	gtk_widget_add_events(
	    w,
	    GDK_KEY_PRESS_MASK | GDK_KEY_RELEASE_MASK |
	    GDK_ENTER_NOTIFY_MASK | GDK_LEAVE_NOTIFY_MASK |
	    GDK_BUTTON_PRESS_MASK | GDK_BUTTON_RELEASE_MASK |
	    GDK_POINTER_MOTION_MASK | GDK_POINTER_MOTION_HINT_MASK
	);
	gtk_signal_connect(
	    GTK_OBJECT(w), "button_press_event",
	    GTK_SIGNAL_FUNC(ASCIIChartDlgCListEventCB), d
	);
	gtk_signal_connect(
	    GTK_OBJECT(w), "button_release_event",
	    GTK_SIGNAL_FUNC(ASCIIChartDlgCListEventCB), d
	);
	gtk_signal_connect(
	    GTK_OBJECT(w), "motion_notify_event",
	    GTK_SIGNAL_FUNC(ASCIIChartDlgCListEventCB), d
	);
	gtk_signal_connect(
	    GTK_OBJECT(w), "select_row",
	    GTK_SIGNAL_FUNC(ASCIIChartDlgCListSelectRowCB), d
	);
	gtk_signal_connect(
	    GTK_OBJECT(w), "unselect_row",
	    GTK_SIGNAL_FUNC(ASCIIChartDlgCListUnselectRowCB), d
	);
	gtk_container_add(GTK_CONTAINER(parent2), w);
	gtk_widget_realize(w);
	gtk_clist_set_selection_mode(clist, GTK_SELECTION_SINGLE);
	gtk_clist_set_row_height(clist, EDV_LIST_ROW_SPACING);
	gtk_clist_set_shadow_type(clist, GTK_SHADOW_IN);
	gtk_clist_column_titles_show(clist);
	gtk_clist_column_titles_passive(clist);
	gtk_clist_set_column_justification(
	    clist, 0, GTK_JUSTIFY_LEFT
	);
	gtk_clist_set_column_auto_resize(clist, 0, TRUE);
	gtk_clist_set_column_justification(
	    clist, 1, GTK_JUSTIFY_LEFT
	);
	gtk_clist_set_column_auto_resize(clist, 1, TRUE);
	gtk_clist_set_column_justification(
	    clist, 2, GTK_JUSTIFY_LEFT
	);
	gtk_clist_set_column_auto_resize(clist, 2, TRUE);
	gtk_clist_set_column_justification(
	    clist, 3, GTK_JUSTIFY_LEFT
	);
	gtk_clist_set_column_auto_resize(clist, 3, TRUE);
	gtk_clist_set_column_justification(
	    clist, 4, GTK_JUSTIFY_LEFT
	);
	gtk_clist_set_column_auto_resize(clist, 4, TRUE);
	gtk_widget_show(w);
	/* Add each ASCII value */
	if(clist != NULL)
	{
	    gint row;
	    guint32 v;
	    const gchar *desc_list[] = ASCII_CHART_DLG_DESC_LIST;
	    gchar *strv[5];

	    gtk_clist_freeze(clist);

	    /* Values */
	    for(v = 0x00; v <= 0xff; v++)
	    {
		strv[0] = g_strdup_printf("0x%.2X", v);
		strv[1] = g_strdup_printf("%i", v);
		strv[2] = g_strdup_printf("%.4o", v);
		if((v == '\n') || (v == '\r') || (v == '\t') || (v == '\v'))
		    strv[3] = g_strdup("");
		else
		    strv[3] = g_strdup_printf("%c", (gchar)v);
		strv[4] = g_strdup(desc_list[v]);
		row = gtk_clist_append(clist, strv);
		g_free(strv[0]);
		g_free(strv[1]);
		g_free(strv[2]);
		g_free(strv[3]);
		g_free(strv[4]);
		if(row < 0)
		    break;

		gtk_clist_set_row_data(
		    clist,
		    row,
		    (gpointer)v
		);
	    }

	    gtk_clist_thaw(clist);
	}
	gtk_clist_columns_autosize(clist);

	/* Buttons GtkHBox */
	w = gtk_hbox_new(FALSE, 0);
	gtk_box_pack_start(GTK_BOX(parent), w, FALSE, FALSE, border_major);
	gtk_widget_show(w);
	parent2 = w;

	/* Copy to clipboard button */
	d->copy_btn = w = GUIButtonPixmapLabelH(
	    (guint8 **)icon_copy_20x20_xpm, "Copy", NULL
	);
	gtk_widget_set_usize(
	    w,
	    GUI_BUTTON_HLABEL_WIDTH, GUI_BUTTON_HLABEL_HEIGHT
	);
	gtk_box_pack_end(GTK_BOX(parent2), w, FALSE, FALSE, border_major);
	gtk_signal_connect(
	    GTK_OBJECT(w), "clicked",
	    GTK_SIGNAL_FUNC(ASCIIChartDlgCopyToClipboardCB), d
	);
	gtk_accel_group_add(
	    accelgrp, GDK_c, GDK_CONTROL_MASK, GTK_ACCEL_VISIBLE,
	    GTK_OBJECT(w), "clicked"
	);
	gtk_accel_group_add(
	    accelgrp, GDK_v, GDK_CONTROL_MASK, GTK_ACCEL_VISIBLE,
	    GTK_OBJECT(w), "clicked"
	);
	GUIButtonLabelUnderline(w, GDK_c);
	gtk_widget_show(w);

	w = gtk_hseparator_new();
	gtk_box_pack_start(GTK_BOX(parent), w, FALSE, FALSE, 0);
	gtk_widget_show(w);


	/* Buttons GtkHBox */
	w = gtk_hbox_new(TRUE, 0);
	gtk_box_pack_start(GTK_BOX(parent), w, FALSE, FALSE, border_major);
	gtk_widget_show(w);
	parent2 = w;

	/* OK button */
	d->ok_btn = w = GUIButtonPixmapLabelH(
	    (guint8 **)icon_ok_20x20_xpm, "OK", NULL
	);
	GTK_WIDGET_SET_FLAGS(w, GTK_CAN_DEFAULT);
	gtk_widget_set_usize(
	    w,
	    GUI_BUTTON_HLABEL_WIDTH_DEF, GUI_BUTTON_HLABEL_HEIGHT_DEF
	);
	gtk_box_pack_start(GTK_BOX(parent2), w, TRUE, FALSE, 0);
	gtk_signal_connect(
	    GTK_OBJECT(w), "clicked",
	    GTK_SIGNAL_FUNC(ASCIIChartDlgOKCB), d
	);
	gtk_accel_group_add(
	    accelgrp, GDK_Escape, 0, GTK_ACCEL_VISIBLE,
	    GTK_OBJECT(w), "clicked"
	);
	gtk_accel_group_add(
	    accelgrp, GDK_o, GDK_CONTROL_MASK, GTK_ACCEL_VISIBLE,
	    GTK_OBJECT(w), "clicked"
	);
	GUIButtonLabelUnderline(w, GDK_o);
	gtk_widget_show(w);


	/* Right-click popup GtkMenu */
	if(TRUE)
	{
#define DO_ADD_MENU_ITEM_LABEL  {               \
 w = GUIMenuItemCreate(                         \
  menu, GUI_MENU_ITEM_TYPE_LABEL, accelgrp,     \
  icon, label, accel_key, accel_mods, NULL,     \
  mclient_data, func_cb                         \
 );                                             \
}
#define DO_ADD_MENU_ITEM_CHECK  {               \
 w = GUIMenuItemCreate(                         \
  menu, GUI_MENU_ITEM_TYPE_CHECK, accelgrp,     \
  icon, label, accel_key, accel_mods, NULL,     \
  mclient_data, func_cb                         \
 );                                             \
}
#define DO_ADD_MENU_SEP         {               \
 w = GUIMenuItemCreate(                         \
  menu, GUI_MENU_ITEM_TYPE_SEPARATOR, NULL,     \
  NULL, NULL, 0, 0, NULL,                       \
  NULL, NULL                                    \
 );                                             \
}

	    GtkWidget *menu = GUIMenuCreate();
	    guint8 **icon;
	    const gchar *label;
	    gint accel_key;
	    guint accel_mods;
	    GtkAccelGroup *accelgrp = NULL;
	    gpointer mclient_data = d;
	    void (*func_cb)(GtkWidget *w, gpointer);

	    icon = (guint8 **)icon_copy_20x20_xpm;
	    label =
#if defined(PROG_LANGUAGE_SPANISH)
"Copia"
#elif defined(PROG_LANGUAGE_FRENCH)
"Copier"
#elif defined(PROG_LANGUAGE_GERMAN)
"Kopie"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Copia"
#elif defined(PROG_LANGUAGE_DUTCH)
"Kopie"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Cpia"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Kopi"
#else
"Copy"
#endif
	    ;
	    accel_key = GDK_C;
	    accel_mods = GDK_CONTROL_MASK;
	    func_cb = ASCIIChartDlgCopyToClipboardCB;
	    DO_ADD_MENU_ITEM_LABEL
	    d->copy_mi = w;

	    d->menu = menu;

#undef DO_ADD_MENU_ITEM_LABEL
#undef DO_ADD_MENU_ITEM_CHECK
#undef DO_ADD_MENU_SEP
	}


	ASCIIChartDlgUpdateMenus(d);

	d->freeze_count--;

	return(d);
}

/*
 *	Updates the ASCII Chart Dialog's widgets to reflect current
 *	values.
 */
void ASCIIChartDlgUpdateMenus(ascii_chart_dlg_struct *d)
{
	gboolean b;
	GtkCList *clist;

	if(d == NULL)
	    return;

	d->freeze_count++;

	clist = GTK_CLIST(d->clist);

	b = (clist->selection != NULL) ? TRUE : FALSE;
	gtk_widget_set_sensitive(d->copy_btn, b);
	gtk_widget_set_sensitive(d->copy_mi, b);



	d->freeze_count--;
}

/*
 *	Checks if the ASCII Chart Dialog is mapped.
 */
gboolean ASCIIChartDlgIsMapped(ascii_chart_dlg_struct *d)
{
	if(d == NULL)
	    return(FALSE);

	return(GTK_WIDGET_MAPPED(d->toplevel));
}

/*
 *	Maps the ASCII Chart Dialog.
 */
void ASCIIChartDlgMap(ascii_chart_dlg_struct *d)
{
	GtkWidget *w;

	if(d == NULL)
	    return;

	gtk_widget_show_raise(d->toplevel);

	/* Grab focus and default on the OK button */
	w = d->ok_btn;
	gtk_widget_grab_focus(w);
	gtk_widget_grab_default(w);
}

/*
 *	Unmap the ASCII Chart Dialog.
 */
void ASCIIChartDlgUnmap(ascii_chart_dlg_struct *d)
{
	if(d == NULL)
	    return;

	gtk_widget_hide(d->toplevel);
}

/*
 *	Deletes the ASCII Chart Dialog.
 */
void ASCIIChartDlgDelete(ascii_chart_dlg_struct *d)
{
	if(d == NULL)
	    return;

	ASCIIChartDlgUnmap(d);
	gtk_window_set_modal(GTK_WINDOW(d->toplevel), FALSE);
	gtk_window_set_transient_for(GTK_WINDOW(d->toplevel), NULL);

	d->freeze_count++;

	GTK_WIDGET_DESTROY(d->menu);
	GTK_WIDGET_DESTROY(d->toplevel);
	GTK_ACCEL_GROUP_UNREF(d->accelgrp);

	d->freeze_count--;

	g_free(d);
}
