/*
			     Desktop Icon
 */

#ifndef DESKTOP_ICON_H
#define DESKTOP_ICON_H

#include <gtk/gtk.h>


typedef struct _desktop_icon_struct	desktop_icon_struct;
#define DESKTOP_ICON(p)			((desktop_icon_struct *)(p))


/*
 *	Flags:
 */
typedef enum {
	DESKICON_CAN_SELECT		= (1 << 0),
	DESKICON_CAN_MOVE		= (1 << 1),
	DESKICON_IS_MOVING		= (1 << 2),
	DESKICON_CAN_RENAME		= (1 << 3),
	DESKICON_ALWAYS_ON_TOP		= (1 << 4)
} desktop_icon_flags;


/*
 *	Desktop Icon:
 */
struct _desktop_icon_struct {

	gboolean	map_state;
	gint		freeze_count;
	GdkGC		*gc;

	desktop_icon_flags	flags;

	/* Icon GtkWidgets and resources */
	GtkWidget	*icon_toplevel,
			*icon_da;
	guint8		**last_icon_data;
	GdkPixmap	*icon_pixmap;
	GdkBitmap	*icon_mask;
	gint		icon_width,
			icon_height;

	/* Label GtkWidgets and resources */
	GtkWidget	*label_toplevel,
			*label_da;
	gchar		*label_str;
	gint		label_width,
			label_height,
			label_str_lbearing,	/* String extents */
			label_str_rbearing,
			label_str_width,
			label_str_ascent,
			label_str_descent;

	/* Popup GtkMenu */
	GtkWidget	*menu;

	/* Last button that was pressed and pointer drag position */
	gint		button,
			drag_last_x,
			drag_last_y;

	/* Callbacks
	 *
	 * Map referenced window, called on double-clicks
	 */
	void		(*activate_cb)(
		gpointer,		/* Deskicon */
		gpointer		/* Data */
	);
	gpointer	activate_data;

	/* Select callback, called when deskicon is selected */
	void		(*select_cb)(
		gpointer,		/* Deskicon */
		gpointer		/* Data */
	);
	gpointer	select_data;

	/* Unselect callback, called when deskicon is unselected */
	void		(*unselect_cb)(
		gpointer,		/* Deskicon */
		gpointer		/* Data */
	);
	gpointer	unselect_data;

	/* Rename callback, called when deskicon label has changed */
	void		(*rename_cb)(
		gpointer,		/* Deskicon */
		const gchar *,		/* Old Name */
		const gchar *,		/* New Name */
		gpointer		/* Data */
	);
	gpointer	rename_data;

	/* Move begin callback, called at the beginning of any move */
	void		(*move_begin_cb)(
		gpointer,		/* Deskicon */
		gint, gint,		/* Position */
		gpointer		/* Data */
	);
	gpointer	move_begin_data;

	/* Moving callback, called during any movement */
	void		(*moving_cb)(
		gpointer,		/* Deskicon */
		gint, gint,		/* Position */
		gpointer		/* Data */
	);
	gpointer	moving_data;

	/* Moved callback, called after each move */
	void		(*moved_cb)(
		gpointer,		/* Deskicon */
		gint, gint,		/* Position */
		gpointer		/* Data */
	);
	gpointer	moved_data;

};


#define DeskIconGetFlags(p)	(((p) != NULL) ? DESKTOP_ICON(p)->flags : 0)
extern void DeskIconSetFlags(
	desktop_icon_struct *di, guint flags
);
extern void DeskIconUnsetFlags(
        desktop_icon_struct *di, guint flags
);

extern void DeskIconGetPosition(
	desktop_icon_struct *di, gint *x, gint *y
);
extern void DeskIconSetPosition(
	desktop_icon_struct *di,
	const gint x, const gint y
);

extern desktop_icon_struct *DeskIconNew(
	const gint x, const gint y,
	guint8 **icon_data, const gchar *label
);

extern void DeskIconSet(
	desktop_icon_struct *di,
	guint8 **icon_data, const gchar *label
);

extern gboolean DeskIconIsSensitive(desktop_icon_struct *di);
extern void DeskIconSetSensitive(
	desktop_icon_struct *di, const gboolean sensitive
);

extern gboolean DeskIconIsSelected(desktop_icon_struct *di);
extern void DeskIconSelect(desktop_icon_struct *di);
extern void DeskIconUnselect(desktop_icon_struct *di);

extern void DeskIconSetMapRefCB(
	desktop_icon_struct *di,
	void (*activate_cb)(gpointer, gpointer),
	gpointer data
);
extern void DeskIconSetSelectCB(
        desktop_icon_struct *di,
        void (*select_cb)(gpointer, gpointer),
        gpointer data
);
extern void DeskIconSetUnselectCB(
        desktop_icon_struct *di,
        void (*unselect_cb)(gpointer, gpointer),
        gpointer data
);
extern void DeskIconSetRenameCB(
        desktop_icon_struct *di,
        void (*rename_cb)(gpointer, const gchar *, const gchar *, gpointer),
        gpointer data
);
extern void DeskIconSetMoveBeginCB(
        desktop_icon_struct *di,
        void (*move_begin_cb)(gpointer, gint, gint, gpointer),
        gpointer data
);
extern void DeskIconSetMovingCB(
        desktop_icon_struct *di,
        void (*moving_cb)(gpointer, gint, gint, gpointer),
        gpointer data
);
extern void DeskIconSetMovedCB(
	desktop_icon_struct *di,
	void (*moved_cb)(gpointer, gint, gint, gpointer),
	gpointer data
);

extern void DeskIconSetMenu(desktop_icon_struct *di, GtkWidget *w);
extern GtkWidget *DeskIconGetMenu(desktop_icon_struct *di);

extern void DeskIconMap(desktop_icon_struct *di);
extern void DeskIconUnmap(desktop_icon_struct *di);

extern void DeskIconDelete(desktop_icon_struct *di);


#endif	/* DESKTOP_ICON_H */
